/*******************************************************************************
 * Copyright (c) 2005, 2009 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: EventLabelProvider.java,v 1.5 2009/05/15 18:58:26 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.editor.form.util;

import org.eclipse.hyades.models.common.testprofile.TPFExecutionEvent;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.test.ui.editor.form.util.IEventLabelProvider;
import org.eclipse.hyades.test.ui.internal.editor.form.DefaultLabelProvider;
import org.eclipse.hyades.test.ui.internal.editor.form.base.Partition;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.graphics.Image;

/**
 * <p>Event label provider.</p>
 * 
 * 
 * @author  Paul E. Slauenwhite
 * @author  Karine Darcourt
 * @author  Blazej Kroll
 * @version May 15, 2009
 * @since   March 16, 2005
 */
public class EventLabelProvider implements ILabelProvider 
{
	public IEventLabelProvider getProvider(String type) 
	{
		return ExecutionHistoryExtensionsManager.getInstance().getEventLabelProvider(type);
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.ILabelProvider#getImage(java.lang.Object)
	 */
	public Image getImage(Object element) 
	{
		Image icon = null;
		DefaultLabelProvider defaultProv = new DefaultLabelProvider();
		
		if (element instanceof Partition)
		{
			icon = ((Partition)(element)).getImage();			
		}
		else if (element instanceof TPFExecutionResult) 
		{
			TPFExecutionResult execResult = (TPFExecutionResult) element;
			IEventLabelProvider provider = getProvider(execResult.getType());
			if(provider != null) 
				icon = provider.getImage(element);
			else
				icon = defaultProv.getImage(element); 
		} 
		else if (element instanceof TPFExecutionEvent) 
		{
			TPFExecutionEvent execEvent = (TPFExecutionEvent) element;
			IEventLabelProvider provider = getProvider(execEvent.getEventType());
			if(provider != null) 
				icon = provider.getImage(element);
			else 
				icon = defaultProv.getImage(element);
		}		
		return icon;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.ILabelProvider#getText(java.lang.Object)
	 */
	public String getText(Object element) 
	{
		String label = ""; //$NON-NLS-1$
		DefaultLabelProvider defaultProv = new DefaultLabelProvider();
		
		if (element instanceof Partition)
		{
			label = ((Partition)(element)).getLabel();		
		}
		else if (element instanceof TPFExecutionResult) 
		{
			TPFExecutionResult execResult = (TPFExecutionResult) element;
			IEventLabelProvider provider = getProvider(execResult.getType());
			if(provider != null) 
				label = provider.getText(element);
			else
				label = defaultProv.getText(element); 
		} 
		else if (element instanceof TPFExecutionEvent) 
		{
			TPFExecutionEvent execEvent = (TPFExecutionEvent) element;
			IEventLabelProvider provider = getProvider(execEvent.getEventType());
			if(provider != null) 
				label = provider.getText(element);
			else
				label = defaultProv.getText(element); 
		}
		return (TextProcessor.process(label));
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.IBaseLabelProvider#addListener(org.eclipse.jface.viewers.ILabelProviderListener)
	 */
	public void addListener(ILabelProviderListener listener) {
		// TODO Auto-generated method stub
	}
	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.IBaseLabelProvider#dispose()
	 */
	public void dispose() {
		// TODO Auto-generated method stub
	}
	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.IBaseLabelProvider#isLabelProperty(java.lang.Object, java.lang.String)
	 */
	public boolean isLabelProperty(Object element, String property) {
		// TODO Auto-generated method stub
		return false;
	}
	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.IBaseLabelProvider#removeListener(org.eclipse.jface.viewers.ILabelProviderListener)
	 */
	public void removeListener(ILabelProviderListener listener) {
		// TODO Auto-generated method stub
	}
}
