/**********************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: EventSection.java,v 1.7 2007/03/22 14:42:08 paules Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.ui.internal.editor.form.util;

import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionEvent;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionHistory;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.models.common.testprofile.TPFInvocationEvent;
import org.eclipse.hyades.test.ui.editor.form.util.EditorForm;
import org.eclipse.hyades.test.ui.internal.action.GetNextFailAction;
import org.eclipse.hyades.test.ui.internal.action.GetPrevFailAction;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.actions.SelectionListenerAction;

public class EventSection extends EObjectTreeSection {
    
    protected GetNextFailAction getNextFailAction;
    protected GetPrevFailAction getPrevFailAction;

    public EventSection(EditorForm editorForm,
            EStructuralFeature eStructuralFeature, IAction addAction) {
        super(editorForm, eStructuralFeature, addAction);
    }

    public static class EventContentProvider
    extends EObjectTreeSection.EObjectContainerContentProvider
    { 
        public EventContentProvider(EditorForm editorForm, EStructuralFeature eStructuralFeature) {
            super(editorForm, eStructuralFeature);
        }
        
        protected Object getRegisteredParentChild(Object parent)
        {
            if(parent instanceof TPFExecutionResult)
            {
                TPFExecutionResult executionResult = (TPFExecutionResult)parent;
                if(executionResult.getExecutionHistory() != null)
                    return executionResult.getExecutionHistory().getExecutionEvents();
                return null;
            }
            //added to set the parent/child hierarchy for execution events :BGB(12/2/03)
            else if (parent instanceof TPFExecutionEvent)
            {
                if ( parent instanceof TPFInvocationEvent )
                {
                    TPFInvocationEvent invocationEvent  = (TPFInvocationEvent)parent;
                    return( invocationEvent.getInvokedExecutionResult() );
                }
                else
                {
                    TPFExecutionEvent   executionEvent  = (TPFExecutionEvent)parent;
                    if ( ( executionEvent.getChildren() != null ) &&
                         ( executionEvent.getChildren().isEmpty() == false ))
                        return( executionEvent.getChildren());
                }
            }
            return super.getRegisteredParentChild(parent);
        }
        
        public Object getParent(Object element)
        {
            if(element instanceof TPFExecutionResult)
            {
                TPFExecutionResult executionResult = (TPFExecutionResult)element;
                if(executionResult.getInvocationExecutionEvent() != null)
                    return executionResult.getInvocationExecutionEvent();
            }
            //added to set the parent/child hierarchy for execution events :BGB(12/2/03)
            else if (element instanceof TPFExecutionEvent)
            {
                TPFExecutionEvent executionEvent    = (TPFExecutionEvent)element;
                if (executionEvent.eContainer() instanceof TPFExecutionHistory)
                {
					//- added to return the TPFExecutionResult in case the eContainer is a TPFExecutionHistory
					TPFExecutionHistory exhis = (TPFExecutionHistory)executionEvent.eContainer();
					TPFExecutionResult exres = exhis.getExecutionResult();
					if (exres.eContainer() == null) return exhis;
					else return exhis.getExecutionResult();
                }
                else 
                    return( executionEvent.eContainer());
            }
            
            return super.getParent(element);
        }

    }
    
    /**
     * @see org.eclipse.hyades.test.ui.internal.editor.form.util.EObjectTreeSection#createContentProvider()
     */
    protected IContentProvider createContentProvider()
    {
        return new EventContentProvider(getEditorForm(), getEStructuralFeature());
    }

    protected void adjustButtonLabels(String addLabel)
    {
        setButtonLabels(new String[]{UiPluginResourceBundle.LBL_PREV_ERROR,UiPluginResourceBundle.LBL_NEXT_ERROR},new String []{UiPluginResourceBundle.TOOLTIP_PREV_ERROR,UiPluginResourceBundle.TOOLTIP_NEXT_ERROR});
        getNextFailAction = new GetNextFailAction();
        getPrevFailAction = new GetPrevFailAction();
    }
    
    protected void buttonSelected(int index)
    {
        if(!isReadOnly())
        {
            switch(index)
            {
                case 0:
                    doGetPrevFail();
                    break;
    
                case 1:
                    doGetNextFail();
                    break;
            }
        }
        
        updateActionsAndButtons(getStructuredSelection());
    }
    
    protected void doGetPrevFail(){
        if(getPrevFailAction != null)
            getPrevFailAction.run();
    }
    
    protected void doGetNextFail(){
        if(getNextFailAction != null)
            getNextFailAction.run();
    }

    
    public void dispose() {
        getNextFailAction=null;
        getPrevFailAction=null;
        super.dispose();
    }
    
    protected ILabelProvider createLabelProvider() 
    {
        return new EventLabelProvider();
    }
    
    public void setGetNextFailAction(GetNextFailAction getNextFailAction) {
        this.getNextFailAction = getNextFailAction;
    }
    
    public void setGetPrevFailAction(GetPrevFailAction getPrevFailAction) {
        this.getPrevFailAction = getPrevFailAction;
    }
    
    protected void createActions()
    {   
        super.createActions();
        EventContentProvider ecp = new EventContentProvider(getEditorForm(),getEStructuralFeature());
        if (getPrevFailAction!=null) {
            getPrevFailAction.setEcp(ecp);
            getPrevFailAction.setEnabled(false);
        }
        if (getNextFailAction!=null) {
            getNextFailAction.setEcp(ecp);
            getNextFailAction.setEnabled(false);
        }

    }
    
    /**
     * @see org.eclipse.hyades.test.ui.internal.editor.form.base.BaseTreeSection#adjustClient(org.eclipse.swt.widgets.Composite)
     */
    protected void adjustClient(Composite parent)
    {
        getTreeViewer().setContentProvider(createContentProvider());
        getTreeViewer().setLabelProvider(createLabelProvider());
        getTreeViewer().setAutoExpandLevel(0);

        if(getPrevFailAction != null);
            getPrevFailAction.setStructuredViewer(getTreeViewer());

        if(getNextFailAction != null);
            getNextFailAction.setStructuredViewer(getTreeViewer());        
    }
    
    /**
     * @see org.eclipse.hyades.test.ui.internal.editor.form.base.BaseStructuredViewerSection#updateActionsAndButtons(org.eclipse.jface.viewers.IStructuredSelection)
     */
    protected void updateActionsAndButtons(IStructuredSelection structuredSelection)
    {
      
        if(getNextFailAction != null)
        {
            ((SelectionListenerAction)getNextFailAction).selectionChanged(structuredSelection);
            getTreePart().setButtonEnabled(1, getNextFailAction.isEnabled());
        }           
        if(getPrevFailAction != null)
        {
            ((SelectionListenerAction)getPrevFailAction).selectionChanged(structuredSelection);
            getTreePart().setButtonEnabled(0, getPrevFailAction.isEnabled());
        }
    }
    
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.util.StructuredViewerSection#getPopupMenuId()
	 */
	protected String getPopupMenuId() {
		return "#events";
	}
}
