/*******************************************************************************
 * Copyright (c) 2005, 2010 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ExtensibleEObjectTreeSection.java,v 1.4 2010/02/16 20:21:33 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.editor.form.util;

import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.test.ui.adapter.TestWorkbenchAdapter;
import org.eclipse.hyades.test.ui.editor.form.util.EObjectContainerContentProvider;
import org.eclipse.hyades.test.ui.editor.form.util.EditorForm;
import org.eclipse.hyades.test.ui.internal.model.ui.ChildrenSelectionAction;
import org.eclipse.hyades.ui.internal.action.CollapseAllAction;
import org.eclipse.hyades.ui.internal.provider.WorkbenchAdapterLabelProvider;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.eclipse.ui.part.DrillDownAdapter;

/**
 * <p>An <code>EObject</code> tree view section with configurable buttons.</p>
 * 
 * <p>The sole constructor of this class takes all the button actions in an array, which
 * will be used to create the buttons and will be invoked when the button is selected.</p>
 * 
 * 
 * @author  Bianca Jiang Xue
 * @author  Paul Slauenwhite
 * @version February 16, 2010
 * @since   February 1, 2005
 * @deprecated Use {@link org.eclipse.hyades.test.ui.editor.form.util.ExtensibleEObjectTreeSection}.
 */
public class ExtensibleEObjectTreeSection extends TreeSection {
	
	private IAction[] buttonActions;
	private EStructuralFeature eStructuralFeature;
	protected DrillDownAdapter drillDownAdapter;
	protected CollapseAllAction collapseAllAction;
	private boolean editable;

	/**
	 * Constructor for ExtendedEObjectTreeSection
	 * @param editorForm
	 * @param eStructuralFeature
	 * @param addAction
	 */
	public ExtensibleEObjectTreeSection(EditorForm editorForm, EStructuralFeature eStructuralFeature, IAction[] buttonActions)
	{
		super(editorForm);
		this.eStructuralFeature = eStructuralFeature;
		this.buttonActions = buttonActions;
		String[] buttonLabels = new String[buttonActions.length];
		for(int i = 0; i < buttonActions.length; i++)
		{
			buttonLabels[i] = buttonActions[i].getText();
		}

		super.setButtonLabels(buttonLabels);		
	}
	
	/**
	 * @see org.eclipse.update.ui.forms.internal.FormSection#dispose()
	 */
	public void dispose()
	{
		eStructuralFeature = null;
		
		for(int i = 0; i < buttonActions.length; i++)
		{
			if(buttonActions[i] != null)
				buttonActions[i] = null;
		}

		super.dispose();
	}	
	
	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.base.BaseTreeSection#adjustClient(org.eclipse.swt.widgets.Composite)
	 */
	protected void adjustClient(Composite parent)
	{
		getTreeViewer().setContentProvider(createContentProvider());
		getTreeViewer().setLabelProvider(createLabelProvider());
		getTreeViewer().setAutoExpandLevel(0);
		
		for(int i = 0; i < buttonActions.length; i++)
		{
			if(buttonActions[i] != null)
			{
				if(buttonActions[i] instanceof ChildrenSelectionAction)
					((ChildrenSelectionAction)buttonActions[i]).setStructuredViewer(getTreeViewer());
				getTreePart().setButtonEnabled(i, buttonActions[i].isEnabled());
			}
		}
	}
	
	/**
	 * Creates this section's content provider
	 * @return IContentProvider
	 */
	protected IContentProvider createContentProvider()
	{
		return new EObjectContainerContentProvider(getEditorForm(), getEStructuralFeature());
	}

	/**
	 * Creates this section's label provider
	 * @return ILabelProvider
	 */
	protected ILabelProvider createLabelProvider()
	{
		return new WorkbenchAdapterLabelProvider(TestWorkbenchAdapter.class);
	}

	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.base.BaseStructuredViewerSection#createActions()
	 */
	protected void createActions()
	{
		collapseAllAction = new CollapseAllAction(getTreeViewer()).useDefaultDecorators();
		
		drillDownAdapter = new DrillDownAdapter(getTreeViewer());
		getTreeViewer().addSelectionChangedListener(drillDownAdapter);
	}
	
	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.base.BaseStructuredViewerSection#buttonSelected(int)
	 */
	protected void buttonSelected(int index)
	{
		if(!isReadOnly())
		{
			if( index >=0 && index < buttonActions.length )
				buttonActions[index].run();
		}
	
		updateActionsAndButtons(getStructuredSelection());
	}
	
	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.base.BaseStructuredViewerSection#updateActionsAndButtons(org.eclipse.jface.viewers.IStructuredSelection)
	 */
	protected void updateActionsAndButtons(IStructuredSelection structuredSelection)
	{
		if(buttonActions == null || buttonActions.length < 1)
			return;
			
		if(isEditable())
		{
			for(int i = 0; i < buttonActions.length; i++)
			{
				if(buttonActions[i] != null)
				{
					if(buttonActions[i] instanceof SelectionListenerAction)
						((SelectionListenerAction)buttonActions[i]).selectionChanged(structuredSelection);
					getTreePart().setButtonEnabled(i, buttonActions[i].isEnabled());
				}
			}
		}
		else
		{
			for(int i = 0; i < buttonActions.length; i++)
			{
				getTreePart().setButtonEnabled(i, false);
			}
		}
	}
	
	public void setEditable(boolean isEditable)
	{
		this.editable = isEditable;
	}
	
	public boolean isEditable()
	{
		return this.editable;
	}
	
	protected EStructuralFeature getEStructuralFeature()
	{
		return eStructuralFeature;
	}	
}
