/*******************************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: GeneralStructureViewer.java,v 1.3 2007/05/02 19:35:49 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.hyades.test.ui.internal.editor.form.util;

import org.eclipse.hyades.test.ui.internal.editor.form.base.StructuredViewerPart;
import org.eclipse.hyades.ui.editor.IEditorExtension;
import org.eclipse.hyades.ui.internal.util.UIUtil;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.forms.widgets.FormToolkit;


/**
 * This class was created in response to the deprecated APIs about the way that
 * forms are currently handled.
 * 
 * <p>
 * Represents a general structure viewer that can be used by clients to implement trees that
 * use the Eclipse form technology
 * </p>
 * 
 * @author Ali Mehregani & marcelop
 */
abstract public class GeneralStructureViewer 
{
	/* The viewer part */
	protected StructuredViewerPart viewerPart;
	
	private boolean handleDefaultButton;
	
	/* The editor that this structured viewer is apart of */
	protected IEditorExtension editorPart;
	
	
	public GeneralStructureViewer(IEditorExtension editorPart)
	{
		this.editorPart = editorPart;
	}
	
	
	
	protected void createActions()
	{
	}
	
	/**
	 * Creates this section's viewer part. - Required to be implmented
	 * @param buttonLabels
	 * @return StructuredViewerPart
	 */
	abstract protected StructuredViewerPart createViewerPart(String[] buttonLabels);
	
    /**
     * Creates this section's viewer part. - Optional (not required to be implemented)
     * @param buttonLabels
     * @param toolTips
     * @return StructuredViewerPart
     */
    protected StructuredViewerPart createViewerPart(String[] buttonLabels,String[] toolTips)
    {
        return null;
    }
    
    
	protected void createViewerPartControl(Composite parent, int style, int span, FormToolkit toolkit)
	{
		viewerPart.createControl(parent, style, span, toolkit);
		createActions();		
		
		MenuManager popupMenuManager = new MenuManager();
		IMenuListener listener = new IMenuListener()
		{
			public void menuAboutToShow(IMenuManager menuManager)
			{
				fillContextMenu(menuManager);
			}
		};
		popupMenuManager.addMenuListener(listener);
		popupMenuManager.setRemoveAllWhenShown(true);
		Control control = viewerPart.getControl();
		Menu menu = popupMenuManager.createContextMenu(control);
		control.setMenu(menu);
	}
	
	
	/**
	 * @see org.eclipse.update.ui.forms.internal.FormSection#dispose()
	 */
	public void dispose()
	{
		viewerPart = null;
	}
	
//	/**
//	 * Prepares the section to do the paste
//	 */
//	protected void doPaste()
//	{
//		IStructuredSelection structuredSelection = getStructuredSelection();
//		if (structuredSelection.size() >1 )
//			return;
//		
//		Object target = structuredSelection.getFirstElement();
//		
//		Clipboard clipboard = getClipboard();
//		LocalTransfer localTransfer = LocalTransfer.getInstance();
//		Object [] objects = (Object[])clipboard.getContents(localTransfer);
//		if((objects!=null) && (objects.length > 0))
//			doPaste(target, objects);
//	}
	
	
	/**
	 * Subclasses should overwrite to execute the paste.  This method is invoked
	 * only if the objects array has at least one element. 
	 * @param target
	 * @param objects
	 */
	protected void doPaste(Object target, Object[] objects)
	{
	}
	
	protected void entryModified(Object entry, String value)
	{
	}
	
	/**
	 * Subclasses may overwrite to add menu.
	 * @param menuManager
	 */
	protected void fillContextMenu(IMenuManager menuManager)
	{
	}
	
	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.base.BaseEditorSection#getInput()
	 */
	public Object getInput()
	{
		return getViewerPart().getViewer().getInput();
	}
	
	/**
	 * Returns the menu id used for the popup menu associated to the structured viewer.
	 * This id must be used by object contributions from the eclipse UI popup menu
	 * extension point, in order to contribute to the menu.
	 * @return A menu name, or null if popup menu contributions should not be supported by the
	 * viewer popup menu.
	 * @author jcanches
	 */
	protected String getPopupMenuId() {
		return null;
	}
	
	
	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.base.BaseEditorSection#getStructuredSelection()
	 */
	public IStructuredSelection getStructuredSelection()
	{
		return (IStructuredSelection)getViewerPart().getViewer().getSelection();
	}
	
	protected StructuredViewerPart getViewerPart()
	{
		return viewerPart;
	}
	
	
	protected void handleDoubleClick(IStructuredSelection structuredSelection)
	{
	}

	protected boolean isHandlingDefaultButton()
	{
		return handleDefaultButton;
	}
	
	
	protected void selectionChanged(IStructuredSelection structuredSelection)
	{
		/* At the moment selection change notifications are not supported 
		fireSelectionNotification(structuredSelection);
		editorPart.getHyadesEditorPart().setSelection(structuredSelection);
		updateActionsAndButtons(structuredSelection);	 */	
	}
	
	/**
	 * @see org.eclipse.ui.part.ISetSelectionTarget#selectReveal(org.eclipse.jface.viewers.ISelection)
	 */
	public void selectReveal(ISelection selection)
	{
		if(UIUtil.areEquals(getStructuredSelection(), selection))
			return;
		
		getViewerPart().getViewer().setSelection(selection, true);
	}	
	
	/**
	 * @see org.eclipse.update.ui.forms.internal.FormSection#setFocus()
	 */
	public void setFocus()
	{
		getViewerPart().getViewer().getControl().setFocus();
	}
	
	protected void setHandleDefaultButton(boolean handle)
	{
		handleDefaultButton = handle;	
	}
	
	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.base.BaseEditorSection#setInput(java.lang.Object)
	 */
	public void setInput(Object object)
	{
		getViewerPart().getViewer().setInput(object);
		if(object != null)
			updateActionsAndButtons(new StructuredSelection(object));
		else
			updateActionsAndButtons(StructuredSelection.EMPTY);
	}
	
	/**
	 * Sets the button labels.  This method should not be invoked more than once.
	 * @param buttonLabels
	 */
	protected void setButtonLabels(String[] buttonLabels)
	{
		setButtonLabels (buttonLabels, null);
	}
	
	
    /**
     * Sets the button labels.  This method should not be invoked more than once.
     * @param buttonLabels
     * @param tooltips
     */
    protected void setButtonLabels(String[] buttonLabels, String[] tooltips)
    {
        if(viewerPart != null)
            return;
            
        viewerPart = createViewerPart(buttonLabels,tooltips);
        viewerPart.setMinimumSize(50, 50);
    }
    
	/**
	 * Method invoked when the actions and buttons need to be updated.
	 * @param structuredSelection
	 */
	protected void updateActionsAndButtons(IStructuredSelection structuredSelection)
	{
	}
    
}
