/*******************************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IDetailForm.java,v 1.3 2007/05/02 19:35:49 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.editor.form.util;

import org.eclipse.hyades.ui.util.IDisposable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.widgets.FormToolkit;


/**
 * This class was created in response to the deprecated APIs about the way that
 * forms are currently handled.
 * 
 * <p>
 * A representation of the details page
 * </p>
 * 
 * @author Ali Mehregani & jcanches
 */
public interface IDetailForm extends IDisposable
{
	/**
	 * Sets the input of the details page and updates its content to represent
	 * the input object properties.
	 * @param object
	 */
	public void setInput(Object object);
	
	/**
	 * Returns the current details page input.
	 * @return The current details page input.
	 */
	public Object getInput();
	
	/**
	 * Creates the control of the details page.
	 * @param parent The parent control.
	 * @param factory A Widget Factory that may be used for creating advanced widgets within
	 * the details page control.
	 * @param context The context of the details page.
	 * @return The control of the details page.
	 */
	public Control createControl(Composite parent, FormToolkit factory, IDetailPageContext context);
	
	/**
	 * Selects and reveal a selection within the details page. Does nothing if
	 * the selection is not applicable.
	 * @param selection
	 */
	public void selectReveal(ISelection selection);
	
	/**
	 * Returns the current selection within the details page.
	 * @return The current selection. If not applicable, or if the selection is empty,
	 * returns StructuredSelection.EMPTY.
	 */
	public IStructuredSelection getStructuredSelection();
	

}
