/*******************************************************************************
 * Copyright (c) 2005, 2010 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: NodeGeneralInfoSection.java,v 1.8 2010/03/03 14:06:47 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.editor.form.util;

import org.eclipse.hyades.models.common.common.CMNNodeInstance;
import org.eclipse.hyades.models.common.common.CMNNodeType;
import org.eclipse.hyades.test.ui.editor.form.util.EditorForm;
import org.eclipse.hyades.test.ui.editor.form.util.WidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.base.HyperlinkAdapter;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.test.ui.internal.util.TestUIUtilities;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

/**
 * <p>This class implements a general information section of an {@link org.eclipse.hyades.models.common.configuration.CFGLocation} 
 * resource editor that provides an editing field for <i>hostname</i>.</p>
 * 
 * 
 * @author  Paul E. Slauenwhite
 * @author  Bianca Xue Jiang
 * @version March 3, 2010
 * @since   February 1, 2005
 */
public class NodeGeneralInfoSection extends GeneralInfoSection
{
	private StyledText hostnameText;
	
	/**
	 * @param editorForm
	 */
	public NodeGeneralInfoSection(EditorForm editorForm, boolean hasResourceFileInfo)
	{
		super(editorForm, hasResourceFileInfo);
	}
	
	/**
	 * @see org.eclipse.update.ui.forms.internal.FormSection#dispose()
	 */
	public void dispose()
	{
		super.dispose();
		hostnameText.dispose();
	}	
	
	protected void addSouthControls(Composite parent, FormWidgetFactory formWidgetFactory)
	{		
		super.addSouthControls(parent, formWidgetFactory);
		WidgetFactory widgetFactory = getEditorForm().getWidgetFactory();
		
		widgetFactory.createLabel(parent, UiPluginResourceBundle.LBL_HOST_NME); 
		hostnameText = widgetFactory.createStyledText(parent, SWT.FULL_SELECTION | SWT.SINGLE);
		hostnameText.setLayoutData(GridDataUtil.createHorizontalFill());	
		hostnameText.getAccessible().addAccessibleListener(new AccessibleAdapter() {
			public void getName(AccessibleEvent e) {
				e.result = UiPluginResourceBundle.W_HOST_NME;
			}
		});

		widgetFactory.createHyperlinkLabel(parent, UiPluginResourceBundle.TEST_CONNECTION_NAME, new HyperlinkAdapter(){
			
			public void linkActivated(Control linkLabel) {
				TestUIUtilities.testConnection(hostnameText.getText());
			}			
		});
	}
	
	public void setEditable(boolean isEditable)
	{
		super.setEditable(isEditable);
		if(hostnameText != null)
			hostnameText.setEditable(isEditable);
	}	
	
	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.base.BaseEditorSection#setInput(java.lang.Object)
	 */
	public void setInput(Object object)
	{	
		super.setInput(object);
		
		hostnameText.removeModifyListener(this);
		String hostname = null;		
		// TODO replace with CMNNode when available
		if(getNamedElement() instanceof CMNNodeInstance)
		{
			hostname = ((CMNNodeInstance)getNamedElement()).getHostname();
			hostname = (hostname == null) ? "" : hostname; //$NON-NLS-1$
			hostnameText.setText(hostname);
		}
		else if(getNamedElement() instanceof CMNNodeType)
		{
			hostname = ((CMNNodeType)getNamedElement()).getHostname();
			hostname = (hostname == null) ? "" : hostname; //$NON-NLS-1$
			hostnameText.setText(hostname);
		}
		hostnameText.addVerifyKeyListener(this);
		hostnameText.addModifyListener(this);	
	}
	
	/**
	 * @see org.eclipse.swt.events.ModifyListener#modifyText(org.eclipse.swt.events.ModifyEvent)
	 */
	public void modifyText(ModifyEvent e)
	{
		super.modifyText(e);
		if(e.widget == hostnameText)
		{
			if(getNamedElement() instanceof CMNNodeInstance)
				((CMNNodeInstance)getNamedElement()).setHostname(hostnameText.getText());
			else if(getNamedElement() instanceof CMNNodeType)
				((CMNNodeType)getNamedElement()).setHostname(hostnameText.getText());
			getEditorForm().getBaseEditorExtension().markDirty();
		}
	}
}
