/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: StaticDetailPageProvider.java,v 1.2 2005/10/28 22:20:57 bjiang Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.editor.form.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import org.eclipse.hyades.test.ui.editor.form.util.AbstractDetailPage;
import org.eclipse.hyades.test.ui.editor.form.util.IDetailPage;
import org.eclipse.hyades.test.ui.internal.editor.form.util.DetailSection.IDetailPageProvider;

/**
 * Simple implementation of IDetailPageProvider that records a set of
 * associations between an input element type and a DetailPage.
 * This provider provides the same functionality that was built in
 * DetailSection in version 3.x.
 * @author jcanches
 * @since 4.0
 */
public class StaticDetailPageProvider implements IDetailPageProvider {

	private HashMap typeToPageMap = new HashMap();
	
	/**
	 * Records an association between a given java type and a detail page.
	 * This provider will return the detail page for any input element that is
	 * of type objectClass.
	 * @param objectClass A java type.
	 * @param detailPage A Detail Page. This detail page is owned by the provider, ie 
	 * it will be disposed by the provider when the provider is disposed.
	 */
	public void addDetailPage(Class objectClass, IDetailPage detailPage) {
		typeToPageMap.put(objectClass, detailPage);
	}
	
	public IDetailPage getDetailPage(Object element) {
		Iterator it = typeToPageMap.entrySet().iterator();
		while (it.hasNext()) {
			Map.Entry entry = (Map.Entry) it.next();
			if (((Class)entry.getKey()).isAssignableFrom(element.getClass()) ||
				(element instanceof Class && ((Class)entry.getKey()).isAssignableFrom((Class)element))) {
				return (IDetailPage)entry.getValue();
			}
		}
		return null;
	}
	
	/**
	 * Returns whether no association have been registered.
	 * @return
	 */
	public boolean isEmpty() {
		return typeToPageMap.isEmpty();
	}
	
	public void dispose() {
		Iterator it = typeToPageMap.values().iterator();
		while (it.hasNext()) {
			AbstractDetailPage page = (AbstractDetailPage) it.next();
			page.dispose();
		}
	}
	
}
