/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TestLogExtensionsManager.java,v 1.3 2006/04/04 20:37:41 bjiang Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.editor.form.util;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.forms.extensions.provisional.IRecordRepositoryProvider;

/**
 * 
 * 
 * @author bjiang
 *
 */
public class TestLogExtensionsManager {
	
	protected final static String EXTENSION_ELEMENT_PROVIDER = "provider";
	protected final static String EXTENSION_ELEMENT_UNLESS = "unless";
	protected final static String EXTENSION_ATTRIBUTE_TYPE = "type";
	protected final static String EXTENSION_ATTRIBUTE_CLASS = "class";
	protected final static String EXTENSION_ATTRIBUTE_TEST_TYPE = "testType";
	protected final static String EXTENSION_ATTRIBUTE_PROVIDER_TYPE = "providerType";

	private static TestLogExtensionsManager instance;
	private DefectProviderExtension[] defectProviderExtensions;
	private Map unless;
	
	public class DefectProviderExtension
	{
		private IConfigurationElement config;
		private String type;
		private IRecordRepositoryProvider provider;
		
		public DefectProviderExtension(IConfigurationElement configElement)
		{
			this.config = configElement;
		}
		public String getType()
		{
			if(type == null)
				type = config.getAttribute(EXTENSION_ATTRIBUTE_TYPE);
			return type;
		}
		public IRecordRepositoryProvider getProvider(boolean createNew)
		{
			if(provider != null && !createNew)
				return provider;

			try {
				provider = (IRecordRepositoryProvider)config.createExecutableExtension(EXTENSION_ATTRIBUTE_CLASS);
			}
			catch (Exception e) {
				UiPlugin.logError(e);
			}
			return provider;
		}
	}
	
	private TestLogExtensionsManager()
	{
		load();
	}
	
	public static TestLogExtensionsManager getInstance()
	{
		if(instance == null)
			instance = new TestLogExtensionsManager();
		
		return instance;
	}
	
	private void load()
	{
		IExtensionPoint extPoint = Platform.getExtensionRegistry().getExtensionPoint(UiPlugin.getID() + ".testLogRecordRepositoryProvider"); //$NON-NLS-1$
		if (extPoint != null) 
		{
			IConfigurationElement[] members = extPoint.getConfigurationElements();
			List providers = new ArrayList();
			unless = new Hashtable();
			for (int i = 0; i < members.length; i++) 
			{
				IConfigurationElement element = members[i];
				if(EXTENSION_ELEMENT_PROVIDER.equals(element.getName()))
					providers.add(new DefectProviderExtension(element));
				else if(EXTENSION_ELEMENT_UNLESS.equals(element.getName()))
				{
					String testType = element.getAttribute(EXTENSION_ATTRIBUTE_TEST_TYPE);
					List providerTypes = (List)unless.get(testType);
					if(providerTypes == null)
					{
						providerTypes = new ArrayList();
						unless.put(testType, providerTypes);
					}
					providerTypes.add((String)element.getAttribute(EXTENSION_ATTRIBUTE_PROVIDER_TYPE));
				}
			}
			defectProviderExtensions = (DefectProviderExtension[])providers.toArray(new DefectProviderExtension[providers.size()]);
		}
	}
	
	public DefectProviderExtension[] getDefectProviderExtensions()
	{
		return defectProviderExtensions;
	}
	
	public String[] getDisabledProviders(String testType)
	{
		List providers = (List)unless.get(testType);
		if(providers == null)
			return new String[0];
		else
			return (String[])providers.toArray(new String[providers.size()]);
	}
}
