/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TreeSection.java,v 1.3 2005/03/18 15:25:11 dguilbaud Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.editor.form.util;

import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

import org.eclipse.hyades.test.ui.editor.form.util.EditorForm;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.base.StructuredViewerPart;
import org.eclipse.hyades.test.ui.internal.editor.form.base.TreePart;

/**
 * @author marcelop
 * @since 0.3.0
 */
public class TreeSection 
extends StructuredViewerSection
{
	protected class PartAdapter
	extends TreePart
	{
		public PartAdapter(String[] buttonLabels)
		{
			super(buttonLabels);
		}
        public PartAdapter(String[] buttonLabels,String[] toolTips)
        {
            super(buttonLabels,toolTips);
        }
		public void selectionChanged(IStructuredSelection selection)
		{
			TreeSection.this.selectionChanged(selection);
		}
		public void handleDoubleClick(IStructuredSelection selection)
		{
			TreeSection.this.handleDoubleClick(selection);
		}
		public void buttonSelected(Button button, int index)
		{
			TreeSection.this.buttonSelected(index);
			if(isHandlingDefaultButton())
				button.getShell().setDefaultButton(null);
		}
	}

	private int treeStryle = SWT.FULL_SELECTION | SWT.MULTI;
	
	/**
	 * Constructor for BaseTreeSection
	 * @param editorForm
	 * @param buttonLabels
	 */
	public TreeSection(EditorForm editorForm, String[] buttonLabels)
	{
		super(editorForm, buttonLabels);
	}

	/**
	 * Constructor for BaseTreeSection
	 * @param editorForm
	 */
	public TreeSection(EditorForm editorForm)
	{
		super(editorForm);
	}

	/**
	 * Gets the tree style.  The default value is 
	 * <code>SWT.FULL_SELECTION | SWT.MULTI</code>
	 * @return int
	 */
	public int getTreeStryle()
	{
		return treeStryle;
	}

	/**
	 * Sets the tree style.  The default value is 
	 * <code>SWT.FULL_SELECTION | SWT.MULTI</code>
	 * @param treeStryle
	 */
	public void setTreeStryle(int treeStryle)
	{
		this.treeStryle = treeStryle;
	}

	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.common.StructuredViewerSection#createViewerPart(java.lang.String[])
	 */
	protected StructuredViewerPart createViewerPart(String[] buttonLabels)
	{
		return new PartAdapter(buttonLabels);
	}
    
    protected StructuredViewerPart createViewerPart(String[] buttonLabels, String[] toolTips) {
        return new PartAdapter(buttonLabels,toolTips);  }
	
    /**
	 * Returns this section's tree part.
	 * @return TreePart
	 */
	public TreePart getTreePart()
	{
		return (TreePart)getViewerPart();
	}
	
	/**
	 * Returns this section's tree viewer.
	 * @return TreeViewer
	 */
	public TreeViewer getTreeViewer()
	{
		return getTreePart().getTreeViewer();
	}
	
	/**
	 * @see org.eclipse.update.ui.forms.internal.FormSection#createClient(org.eclipse.swt.widgets.Composite, org.eclipse.update.ui.forms.internal.FormWidgetFactory)
	 */
	public Composite createClient(Composite parent, FormWidgetFactory formWidgetFactory)
	{
		setFormWidgetFactory(formWidgetFactory);
		Composite container = createClientContainer(parent, 2, getFormWidgetFactory());
		createViewerPartControl(container, getTreeStryle(), 2, getFormWidgetFactory());
		
		getTreeViewer().setAutoExpandLevel(AbstractTreeViewer.ALL_LEVELS);
		getTreeViewer().getControl().setFocus();

		adjustClient(parent);

		getFormWidgetFactory().paintBordersFor(container);
		return container;
	}
	
	/**
	 * This method helps subclasses to extend the create client method.
	 * @param parent
	 */
	protected void adjustClient(Composite parent)
	{
		
	}

	/**
	 * @see org.eclipse.update.ui.forms.internal.FormSection#expandTo(java.lang.Object)
	 */
	public void expandTo(Object object)
	{
		selectReveal(new StructuredSelection(object));
	}
}
