/*******************************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DeploymentProvider.java,v 1.6 2006/10/27 18:59:10 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.launch.providers;

import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;
import org.eclipse.hyades.models.common.testprofile.TPFTestComponent;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.core.internal.launch.extensions.LaunchConfigurationExtensionsManager;
import org.eclipse.hyades.test.core.launch.extensions.IDeploymentsProvider;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;

/**
 * Provides the available Deployments in the Workspace for a given Test Suite.
 * @author jcanches
 */
public class DeploymentProvider extends LabelProvider implements IStructuredContentProvider, IElementComparer {
	
	public TPFDeployment[] getDeployments(Object testElement) {
		if (testElement == null) return new TPFDeployment[0];
		if (testElement instanceof TPFTestSuite || testElement instanceof TPFTestComponent) {
			// Try a specialized provider for the type of testElement
			IDeploymentsProvider provider = LaunchConfigurationExtensionsManager.getInstance().getDeploymentsProvider(testElement);
			// The return value is never null
			return provider.getDeployments(testElement);
		}
		return new TPFDeployment[0];
	}
	
	public Object[] getElements(Object inputElement) {
		if (inputElement instanceof TPFTestSuite ||
			inputElement instanceof TPFTestComponent) {
			return this.getDeployments(inputElement);
		}
		return new Object[0];
	}
	
	public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
		// NOP
	}
	
	public Image getImage(Object element) {
		return TestUIImages.INSTANCE.getImage(TestUIImages.IMG_DEPLOYMENT);
	}
	
	public String getText(Object element) {
		if (element instanceof TPFDeployment) {
			return ((TPFDeployment)element).getName();
		}
		return "<invalid deployment>"; //$NON-NLS-1$
	}

	/**
	 * Redefine the comparison for TPFDeployment objects so that elements
	 * from a different resource set but that have the same URI are reported
	 * as equal.
	 */
	public boolean equals(Object a, Object b) {
		if (a.equals(b)) {
			return true;
		}
		if (a instanceof TPFDeployment && b instanceof TPFDeployment) {
			TPFDeployment ao = (TPFDeployment)a;
			TPFDeployment bo = (TPFDeployment)b;
			String ai = ao.getId();
			String bi = bo.getId();
			Resource ar = ao.eResource();
			Resource br = bo.eResource();
			if (ar == null && br == null && ai != null && bi != null) {
				return ai.equals(bi);
			}
			return ar != null
				&& br != null
				&& ar.getURI().equals(br.getURI())
				&& ar.getURIFragment(ao).equals(br.getURIFragment(bo));
		}
		return false;
	}

	public int hashCode(Object element) {
		return element.hashCode();
	}
	
}
