/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: LaunchFilter.java,v 1.3 2006/10/27 18:59:10 paules Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.ui.internal.launch.providers;

import org.eclipse.hyades.models.common.testprofile.Common_TestprofileFactory;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.test.core.internal.launch.extensions.LaunchConfigurationExtensionsManager;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.ArtifactProxyNode;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.DatapoolProxyNode;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.DeploymentProxyNode;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.IFilter;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.LocationProxyNode;
import org.eclipse.hyades.test.ui.navigator.IExecutionResultProxyNode;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;

/**
 * A filter for displaying only launchable elements in the launch configuration dialog.
 * 
 * @author pnedelec
 * @since 4.0.0
 */
public class LaunchFilter implements IFilter {
    private String mode;
    private String launchConfigurationType;

    /**
     * Create a new LaunchFilter.
     * @param mode The mode the test should be run under (debug, profile, run...)
     * @param launchConfigurationType The name of the Launch Configuration type used
     * for running the test. A null value denotes the default Hyades Launch Configuration.
     */
    public LaunchFilter(String mode, String launchConfigurationType) {
        super();
        this.mode = mode;
        this.launchConfigurationType = launchConfigurationType;
    }

	public boolean satisfies(String type) {
        //Make a fake TPFTest with the specified type to interrogate the extensions manager
        TPFTest test = Common_TestprofileFactory.eINSTANCE.createTPFTestSuite();
        test.setType(type);
        return LaunchConfigurationExtensionsManager.getInstance().isLaunchableElement(test, mode, launchConfigurationType);
	}

	public boolean satisfies(IProxyNode node) {
        if (node instanceof IExecutionResultProxyNode
        	|| node instanceof ArtifactProxyNode
        	|| node instanceof DatapoolProxyNode
        	|| node instanceof DeploymentProxyNode
        	|| node instanceof LocationProxyNode) return false;
	    return true;
	}
	
	public boolean satisfiesChildren(IProxyNode node) {
		return true;
	}

}
