/*******************************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: MoveChildrenUpAction.java,v 1.5 2007/03/22 14:42:04 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.model.ui;

import java.util.Iterator;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.IStructuredSelection;

import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;

/**
 * @author marcelop
 * @since 0.3.0
 */
public class MoveChildrenUpAction
extends ChildrenSelectionAction
{
	private EStructuralFeature eStructuralFeature;
	
	/**
	 * Constructor for MoveChildrenUpAction
	 */
	public MoveChildrenUpAction()
	{
		super(UiPluginResourceBundle.LBL_UP); 
			
		setToolTipText(UiPluginResourceBundle.ACT_UP_DSC); 
		TestUIImages.INSTANCE.setImageDescriptors(this, TestUIImages.ACT_UP);
	}

	/**
	 * @see org.eclipse.hyades.ui.util.IDisposable#dispose()
	 */
	public void dispose()
	{
		eStructuralFeature = null;
		super.dispose();
	}

	/**
	 * @return
	 */
	public EStructuralFeature getEStructuralFeature()
	{
		return eStructuralFeature;
	}

	/**
	 * @The feature must be not <code>null</code> and a "many" feature. 
	 * @param structuralFeature
	 */
	public void setEStructuralFeature(EStructuralFeature feature)
	{
		eStructuralFeature = null;
		if((feature == null) || (!feature.isMany()))
			return;

		eStructuralFeature = feature;
	}

	/**
	 * All the children must belong to the same parent.
	 * @see org.eclipse.ui.actions.SelectionListenerAction#updateSelection(org.eclipse.jface.viewers.IStructuredSelection)
	 */
	protected boolean updateSelection(IStructuredSelection selection)
	{
		if(eStructuralFeature == null)
			return false;

		if(!super.updateSelection(selection))
			return false;
			
		EObject container = ((EObject)getChildren().get(0)).eContainer();
		
		EList allChildren = null;
		try
		{
			allChildren = (EList)container.eGet(eStructuralFeature);
		}
		catch(RuntimeException re)
		{
			getChildren().clear();
			return false;	
		}
		
		if(allChildren.size() == 1)
		{
			getChildren().clear();
			return false;
		}
		
		if((getChildren().size() == 1) && (allChildren.get(0) == getChildren().get(0)))
		{
			getChildren().clear();
			return false;			
		}
		
		for(Iterator i = getChildren().iterator(); i.hasNext();)
		{
			EObject	child = (EObject)i.next();
			if(child.eContainer() != container)
			{
				getChildren().clear();
				return false;
			}
		}
		
		return true;
	}

	/**
	 * @see org.eclipse.jface.action.IAction#run()
	 */
	public void run()
	{
		setActionPerformed(false);
		if(eStructuralFeature == null)
			return;

		EObject container = ((EObject)getChildren().get(0)).eContainer();
		EList allChildren = (EList)container.eGet(eStructuralFeature);

		int top = 0;
		for(Iterator i=getChildren().iterator(); i.hasNext(); )
		{
			Object element = i.next();
			int index = allChildren.indexOf(element);
			if(index < 0)
				continue;
				
			if(index > top)
				allChildren.move(index, index-1);
			else
				top++;
		}		

		setActionPerformed(true);
	}
}
