/*******************************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: MoveUpChildrenAction.java,v 1.5 2007/03/22 14:42:04 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.model.ui;

import java.util.Iterator;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.action.model.FeatureChildrenSelectionAction;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.jface.viewers.IStructuredSelection;
;

/**
 * This class handles the move up action of elements that are {@link org.eclipse.emf.ecore.EStructuralFeature}
 * of an {@link org.eclipse.emf.ecore.EObject}.
 * 
 * @author bjiang
 * @since  1.3
 * @deprecated @deprecated Use org.eclipse.hyades.test.ui.internal.model.ui.MoveFeatureChildrenUpAction instead.
 */
public class MoveUpChildrenAction extends FeatureChildrenSelectionAction
{
	/**
	 * 
	 */
	public MoveUpChildrenAction(EObject parent, EStructuralFeature feature)
	{
		super(UiPluginResourceBundle.LBL_UP, parent, feature); 

		setToolTipText(UiPluginResourceBundle.ACT_UP_DSC); 
		TestUIImages.INSTANCE.setImageDescriptors(this, TestUIImages.ACT_UP);
	}
	
	/**
	 * All the children must belong to the same parent.
	 * @see org.eclipse.ui.actions.SelectionListenerAction#updateSelection(org.eclipse.jface.viewers.IStructuredSelection)
	 */
	protected boolean updateSelection(IStructuredSelection selection)
	{
		if(!super.updateSelection(selection))
			return false;
		
		EList allChildren = (EList)getEStructuralFeatureValue();
		
		if(allChildren.size() <= 1)
		{
			getChildren().clear();
			return false;
		}
		
		if((getChildren().size() == 1) && (allChildren.get(0) == getChildren().get(0)))
		{
			getChildren().clear();
			return false;			
		}
		
		return true;
	}

	/**
	 * @see org.eclipse.jface.action.IAction#run()
	 */
	public void run()
	{
		setActionPerformed(false);

		EList allChildren = (EList)getEStructuralFeatureValue();
		if(allChildren.size() <= 1)
			return;
		
		int top = 0;
		for(Iterator i=getChildren().iterator(); i.hasNext(); )
		{
			Object element = i.next();
			int index = allChildren.indexOf(element);
			if(index < 0)
				continue;
				
			if(index > top)
				allChildren.move(index, index-1);
			else
				top++;
		}		

		setActionPerformed(true);
	}
}
