/********************************************************************** 
 * Copyright (c) 2005, 2007 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * $Id: DynamicDetailsPage.java,v 1.4 2007/05/02 19:35:49 paules Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/
package org.eclipse.hyades.test.ui.internal.monitor;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

/**
 * Prototype code with internal API usage code commented out, currently not
 * functional but can be used as starting point in the future for continuation
 * of test execution monitor work
 * 
 * @author Scott E. Schneider
 */
class DynamicDetailsPage implements IDetailsPage {

	/*
	 * private static final RGB ACTIVE_RGB = new RGB(232, 242, 254);
	 */

	private IManagedForm form;

	public void createContents(Composite parent) {
		FormToolkit toolkit = this.form.getToolkit();
		parent.setLayout(new TableWrapLayout());
		Composite container = toolkit.createComposite(parent);
		TableWrapLayout layout = new TableWrapLayout();
		layout.numColumns = 2;
		container.setLayout(layout);
		Section header = toolkit.createSection(container, Section.DESCRIPTION);
		header.marginWidth = 0;
		header.marginHeight = 0;
		header.setText("Test Execution Progress Details");
		header
				.setDescription("The test execution steps are enumerated below with status:");
		TableWrapData tableData = new TableWrapData(TableWrapData.FILL_GRAB,
				TableWrapData.FILL_GRAB);
		tableData.colspan = 2;
		header.setLayoutData(tableData);
		Composite separator = toolkit.createCompositeSeparator(header);
		GridData layoutData = new GridData(GridData.HORIZONTAL_ALIGN_FILL);
		layoutData.heightHint = 8;
		separator.setLayoutData(layoutData);
		Composite stepContainer = toolkit.createComposite(header);
		layout = new TableWrapLayout();
		layout.numColumns = 1;
		layout.horizontalSpacing = 0;
		layout.verticalSpacing = 0;
		layout.bottomMargin = 0;
		layout.topMargin = 10;
		layout.leftMargin = 0;
		layout.rightMargin = 0;
		stepContainer.setLayout(layout);
		header.setClient(stepContainer);
		/*
		 * this.createStep(stepContainer,
		 * HelpUIResources.getImage(IHelpUIConstants.IMAGE_FILE_F1TOPIC), "Test
		 * Launching"); this.createStep(stepContainer,
		 * HelpUIResources.getImage(IHelpUIConstants.IMAGE_FILE_F1TOPIC), "Test
		 * Preparation"); this.createStep(stepContainer,
		 * HelpUIResources.getImage(IHelpUIConstants.IMAGE_FILE_F1TOPIC), "Test
		 * Deployment"); this.createStep(stepContainer,
		 * HelpUIResources.getImage(IHelpUIConstants.IMAGE_FILE_F1TOPIC), "Test
		 * Runner Execution (70%)", true, false); this.createStep(stepContainer,
		 * HelpUIResources.getImage(IHelpUIConstants.IMAGE_FILE_F1TOPIC), "Test
		 * Result Collection", false, false);
		 */
		this.form.reflow(true);
	}

	/*
	 * private void createStep(Composite parent, Image image, String text) {
	 * this.createStep(parent, image, text, false); }
	 */

	/*
	 * private void createStep(Composite parent, Image image, String text,
	 * boolean highlight) { this.createStep(parent, image, text, highlight,
	 * true); }
	 */

	/*
	 * private void createStep(Composite parent, Image image, String text,
	 * boolean highlight, boolean isComplete) { FormToolkit toolkit =
	 * this.form.getToolkit(); Composite stepContainer =
	 * toolkit.createComposite(parent); TableWrapLayout tableLayout = new
	 * TableWrapLayout(); tableLayout.numColumns = 2;
	 * tableLayout.verticalSpacing = 0; tableLayout.horizontalSpacing = 0;
	 * stepContainer.setLayout(tableLayout); ImageHyperlink test =
	 * toolkit.createImageHyperlink(stepContainer, SWT.NONE); TableWrapData
	 * layoutData = new TableWrapData(TableWrapData.RIGHT, TableWrapData.TOP);
	 * test.setLayoutData(layoutData); test.setImage(image); Section stepSection =
	 * toolkit.createSection(stepContainer, ExpandableComposite.FOCUS_TITLE |
	 * ExpandableComposite.CLIENT_INDENT | ExpandableComposite.SHORT_TITLE_BAR);
	 * layoutData = new TableWrapData(TableWrapData.FILL, TableWrapData.BOTTOM);
	 * stepSection.setLayoutData(layoutData); stepSection.setText(text);
	 * FormText formText = toolkit.createFormText(stepSection, true);
	 * formText.setText("This is an example of the step description that would
	 * include actual details about each step," + " it will list the most
	 * up-to-date status of the step as well as optional hyperlinks to further
	 * details", false, false); stepSection.setClient(formText); ImageHyperlink
	 * status = toolkit.createImageHyperlink(stepSection, SWT.NONE); if
	 * (isComplete) { //
	 * status.setImage(CheatSheetPlugin.getPlugin().getImage(ICheatSheetResource.CHEATSHEET_ITEM_COMPLETE)); }
	 * stepSection.setTextClient(status); if (highlight) { Color highlightColor =
	 * toolkit.getColors().createColor("highlightColor",
	 * DynamicDetailsPage.ACTIVE_RGB);
	 * stepSection.setBackground(highlightColor);
	 * formText.setBackground(highlightColor);
	 * status.setBackground(highlightColor); } if (!highlight && !isComplete) { // } }
	 */

	public void initialize(IManagedForm form) {
		this.form = form;
	}

	public void dispose() {
	}

	public boolean isDirty() {
		return false;
	}

	public void commit(boolean onSave) {
		System.out.println(onSave);
	}

	public boolean setFormInput(Object input) {
		return false;
	}

	public void setFocus() {
	}

	public boolean isStale() {
		return true;
	}

	public void refresh() {
		this.setFocus();
	}

	public void selectionChanged(IFormPart part, ISelection selection) {
	}

}
