/********************************************************************** 
 * Copyright (c) 2005, 2007 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * $Id: OverviewDetailsBlock.java,v 1.6 2007/05/02 19:35:49 paules Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/
package org.eclipse.hyades.test.ui.internal.monitor;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.DetailsPart;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.IDetailsPageProvider;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.MasterDetailsBlock;

/**
 * Prototype code with internal API usage code commented out, currently not
 * functional but can be used as starting point in the future for continuation
 * of test execution monitor work
 * 
 * @author Scott E. Schneider
 */
class OverviewDetailsBlock extends MasterDetailsBlock {

	private IManagedForm managedForm;

	private OverviewFormPart overviewPart;

	OverviewDetailsBlock() {
	}

	protected void createMasterPart(final IManagedForm managedForm,
			final Composite parent) {

		// Store the managed form
		this.managedForm = managedForm;

		// Set orientation as vertical by default
		this.setHorizontalOrientation();

		// Create overview master part
		this.overviewPart = new OverviewFormPart(parent);

		// Add overview master part to managed form
		managedForm.addPart(this.overviewPart);

	}

	protected void registerPages(DetailsPart detailsPart) {

		// Instantiate dynamic details page (handles details pane)
		final IDetailsPage page = new DynamicDetailsPage();

		// Set-up a dynamic page provider that is rigged to one provider class
		detailsPart.setPageProvider(new IDetailsPageProvider() {
			public Object getPageKey(Object object) {
				return "";
			}

			public IDetailsPage getPage(Object key) {
				return page;
			}
		});

		// Set selection with a dummy object to make details part appear
		detailsPart.selectionChanged(this.overviewPart,
				new StructuredSelection(""));

	}

	protected void createToolBarActions(IManagedForm managedForm) {

		// Retrieve appropriate toolbar manager
		IToolBarManager toolbarManager = managedForm.getForm()
				.getToolBarManager();

		// Create previous details action
		Action previousDetailsAction = new Action(
				"Previous Details", Action.AS_PUSH_BUTTON) { //$NON-NLS-1$
			public void run() {
			}
		};
		previousDetailsAction.setDescription("Previous Details");
		previousDetailsAction.setToolTipText("Previous Details");

		/*
		 * Images need to be copied and not referenced from monitoring plug-in
		 */
		// AcadEditorPluginImages.setImageDescriptors(previousDetailsAction,AcadEditorPluginImages.T_LCL,AcadEditorPluginImages.IMG_UI_PREVIOUS_EVENT);
		// Create next details action
		Action nextDetailsAction = new Action(
				"Next Details", Action.AS_PUSH_BUTTON) { //$NON-NLS-1$
			public void run() {
			}
		};
		nextDetailsAction.setDescription("Next Details");
		nextDetailsAction.setToolTipText("Next Details");

		/*
		 * Images need to be copied and not referenced from monitoring plug-in
		 */
		// AcadEditorPluginImages.setImageDescriptors(nextDetailsAction,AcadEditorPluginImages.T_LCL,AcadEditorPluginImages.IMG_UI_NEXT_EVET);
		// Create horizontal orientation action
		Action horizontalViewAction = new Action(
				"Horizontal View Orientation", Action.AS_RADIO_BUTTON) { //$NON-NLS-1$
			public void run() {
				OverviewDetailsBlock.this.setHorizontalOrientation();
			}
		};
		horizontalViewAction.setChecked(true);
		horizontalViewAction.setDescription("Horizontal View Orientation");
		horizontalViewAction.setToolTipText("Horizontal View Orientation");
		// horizontalViewAction.setImageDescriptor(PDEPluginImages.DESC_HORIZONTAL);
		// horizontalViewAction.setDisabledImageDescriptor(PDEPluginImages.DESC_HORIZONTAL_DISABLED);

		// Create vertical orientation action
		Action verticalViewAction = new Action(
				"Vertical View Orientation", Action.AS_RADIO_BUTTON) { //$NON-NLS-1$
			public void run() {
				OverviewDetailsBlock.this.setVerticalOrientation();
			}
		};
		verticalViewAction.setDescription("Vertical View Orientation");
		verticalViewAction.setToolTipText("Vertical View Orientation");
		// verticalViewAction.setImageDescriptor(PDEPluginImages.DESC_VERTICAL);
		// verticalViewAction.setDisabledImageDescriptor(PDEPluginImages.DESC_VERTICAL_DISABLED);

		// Create maximize overview action
		Action overviewViewOnlyAction = new Action("Overview View Only",
				Action.AS_RADIO_BUTTON) {
			public void run() {
				OverviewDetailsBlock.this.setMaximizeOverview(true);
			}
		};
		overviewViewOnlyAction.setDescription("Overview View Only");
		overviewViewOnlyAction.setToolTipText("Overview View Only");
		// JavaPluginImages.setLocalImageDescriptors(overviewViewOnlyAction,
		// "th_single.gif");

		// Add to appropriate toolbar within form
		toolbarManager.add(previousDetailsAction);
		toolbarManager.add(nextDetailsAction);
		toolbarManager.add(new Separator());
		toolbarManager.add(horizontalViewAction);
		toolbarManager.add(verticalViewAction);
		toolbarManager.add(overviewViewOnlyAction);

	}

	// Maximizes or restores the overview pane in the overview-details block
	private void setMaximizeOverview(boolean maximizeOverview) {
		this.sashForm.setMaximizedControl(maximizeOverview ? this.sashForm
				.getChildren()[0] : null);
	}

	private void setHorizontalOrientation() {
		this.setMaximizeOverview(false);
		this.sashForm.setOrientation(SWT.HORIZONTAL);
		this.managedForm.reflow(true);
	}

	private void setVerticalOrientation() {
		this.setMaximizeOverview(false);
		this.sashForm.setOrientation(SWT.VERTICAL);
		this.managedForm.reflow(true);
	}

	void collapseAll() {
		this.overviewPart.collapseSections();
	}

	void expandAll() {
		this.overviewPart.expandSections();
	}

}