/********************************************************************** 
 * Copyright (c) 2005, 2008 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * $Id: OverviewFormPart.java,v 1.5 2008/04/09 19:58:12 paules Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/
package org.eclipse.hyades.test.ui.internal.monitor;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.AbstractFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

/**
 * Prototype code with internal API usage code commented out, currently not
 * functional but can be used as starting point in the future for continuation
 * of test execution monitor work
 * 
 * @author  Scott E. Schneider
 * @author  Paul E. Slauenwhite
 * @version April 3, 2008
 * @since   April 26, 2005
 */
class OverviewFormPart extends AbstractFormPart {

	// Maintain state for the overview form part
	private Section executingTests;

	private Section completedTests;

	// Maintain parent of overview form part
	private Composite parent;

	/**
	 * Constructing an overview form part rooted in the given parent
	 * 
	 * @param parent
	 *            the composite to parent this part on
	 */
	OverviewFormPart(Composite parent) {
		super();
		this.parent = parent;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.forms.IFormPart#initialize(org.eclipse.ui.forms.IManagedForm)
	 */
	public void initialize(IManagedForm form) {

		// Call base initialize method
		super.initialize(form);

		// Obtain toolkit from managed form
		FormToolkit toolkit = form.getToolkit();

		// Create container for sections within overview pane
		Composite container = toolkit.createComposite(this.parent);
		Layout layout = new TableWrapLayout();
		container.setLayout(layout);

		// Create running tests section (in the future the section qualifier
		// will be configurable)
		this.executingTests = toolkit.createSection(container, Section.EXPANDED
				| Section.TWISTIE | Section.TITLE_BAR);
		this.executingTests.marginWidth = 0;
		this.executingTests.marginHeight = 0;
		this.executingTests.setText("Executing Tests");
		this.executingTests.setLayoutData(new TableWrapData(
				TableWrapData.FILL_GRAB));

		// Create progress bar area for executing tests
		this.createProgressArea(this.executingTests);

		// Create completed tests section (in the future the section qualifier
		// must be configurable)
		this.completedTests = toolkit.createSection(container, Section.EXPANDED
				| Section.TWISTIE | Section.TITLE_BAR);
		this.completedTests.marginWidth = 0;
		this.completedTests.marginWidth = 0;
		this.completedTests.setText("Completed Tests");
		this.completedTests.setLayoutData(new TableWrapData(
				TableWrapData.FILL_GRAB));

		// Create progress bar area for completed tests
		this.createProgressArea(this.completedTests);

	}

	private void createProgressArea(Section parent) {
		/*
		 * NewProgressViewer viewer = new NewProgressViewer(parent, SWT.MULTI |
		 * SWT.H_SCROLL | SWT.V_SCROLL); viewer.setUseHashlookup(true);
		 * ProgressTreeContentProvider provider = new
		 * ProgressTreeContentProvider(viewer, !Policy.DEBUG_SHOW_SYSTEM_JOBS);
		 * viewer.setContentProvider(provider); viewer.setInput(provider);
		 * viewer.setLabelProvider(new ProgressLabelProvider());
		 * parent.setClient(viewer.getControl());
		 */
	}

	/**
	 * Collapse all sections in the overview pane
	 */
	void collapseSections() {
		this.executingTests.setExpanded(false);
		this.completedTests.setExpanded(false);
	}

	/**
	 * Expand all sections in the overview pane
	 */
	void expandSections() {
		this.executingTests.setExpanded(true);
		this.completedTests.setExpanded(true);
	}

}
