/********************************************************************** 
 * Copyright (c) 2005, 2008 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * $Id: TestExecutionMonitor.java,v 1.6 2008/04/09 19:58:12 paules Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/
package org.eclipse.hyades.test.ui.internal.monitor;

import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.ManagedForm;
import org.eclipse.ui.part.ViewPart;

/**
 * Prototype code with internal API usage code commented out, currently not
 * functional but can be used as starting point in the future for continuation
 * of test execution monitor work
 * 
 * @author  Scott E. Schneider
 * @author  Paul E. Slauenwhite
 * @version April 3, 2008
 * @since   April 4, 2005 */
public class TestExecutionMonitor extends ViewPart {

	public static final String ID = "org.eclipse.hyades.test.ui.TestExecutionMonitor"; //$NON-NLS-1$

	private IManagedForm form;

	private OverviewDetailsBlock block;

	public void createPartControl(Composite parent) {
		this.form = new ManagedForm(parent);
		this.form.getForm().setText("Test Executions");
		this.block = new OverviewDetailsBlock();
		this.createToolbarActions();
		this.block.createContent(this.form);
		this.setFocus();
	}

	public void setFocus() {
		this.form.getForm().setFocus();
	}

	private void createToolbarActions() {

		// Retrieve the appropriate toolbar manager
		IToolBarManager toolbarManager = this.getViewSite().getActionBars()
				.getToolBarManager();

		// Create remove finished action
		Action removeFinishedAction = new Action(
				"Remove Finished", Action.AS_PUSH_BUTTON) { //$NON-NLS-1$
			public void run() {
			}
		};
		removeFinishedAction.setDescription("Remove Finished");
		removeFinishedAction.setToolTipText("Remove Finished");
		// SearchPluginImages.setImageDescriptors(removeFinishedAction,
		// SearchPluginImages.T_LCL, SearchPluginImages.IMG_LCL_SEARCH_REM);

		// Create remove all finished action
		Action removeAllFinishedAction = new Action(
				"Remove All Finished", Action.AS_PUSH_BUTTON) { //$NON-NLS-1$
			public void run() {
			}
		};
		removeAllFinishedAction.setDescription("Remove All Finished");
		removeAllFinishedAction.setToolTipText("Remove All Finished");
		// SearchPluginImages.setImageDescriptors(removeAllFinishedAction,
		// SearchPluginImages.T_LCL, SearchPluginImages.IMG_LCL_SEARCH_REM_ALL);

		// Create expand all action
		Action expandAllAction = new Action("Expand All", Action.AS_PUSH_BUTTON) { //$NON-NLS-1$
			public void run() {
				TestExecutionMonitor.this.block.expandAll();
			}
		};
		expandAllAction.setDescription("Expand All");
		expandAllAction.setToolTipText("Expand All");
		// SearchPluginImages.setImageDescriptors(expandAllAction,
		// SearchPluginImages.T_LCL,
		// SearchPluginImages.IMG_LCL_SEARCH_EXPAND_ALL);

		// Create collapse all action
		Action collapseAllAction = new Action(
				"Collapse All", Action.AS_PUSH_BUTTON) { //$NON-NLS-1$
			public void run() {
				TestExecutionMonitor.this.block.collapseAll();
			}
		};
		collapseAllAction.setDescription("Collapse All");
		collapseAllAction.setToolTipText("Collapse All");
		// collapseAllAction.setImageDescriptor(PDEPluginImages.DESC_COLLAPSE_ALL);
		// collapseAllAction.setDisabledImageDescriptor(PDEPluginImages.DESC_COLLAPSE_ALL);

		// Create link details action
		Action lockDetailsAction = new Action("Lock Details",
				Action.AS_CHECK_BOX) {
			public void run() {
			}
		};
		lockDetailsAction.setDescription("Lock Details");
		lockDetailsAction.setToolTipText("Lock Details");
		// JavaPluginImages.setLocalImageDescriptors(lockDetailsAction,
		// "impl_co.gif"); //$NON-NLS-1$

		// Create resume executions action
		Action resumeExecutionAction = new Action("Resume Execution",
				Action.AS_PUSH_BUTTON) {
			public void run() {
			}
		};
		resumeExecutionAction.setDescription("Resume Execution");
		resumeExecutionAction.setToolTipText("Resume Execution");
		TestUIImages.INSTANCE.setImageDescriptors(resumeExecutionAction,
				TestUIImages.IMG_RESUME);

		// Create suspend executions action
		Action suspendExecutionAction = new Action("Suspend Execution",
				Action.AS_PUSH_BUTTON) {
			public void run() {
			}
		};
		suspendExecutionAction.setDescription("Suspend Execution");
		suspendExecutionAction.setToolTipText("Suspend Execution");
		TestUIImages.INSTANCE.setImageDescriptors(suspendExecutionAction,
				TestUIImages.IMG_SUSPEND);

		// Create terminate executions action
		Action terminateExecutionAction = new Action("Terminate Execution",
				Action.AS_PUSH_BUTTON) {
			public void run() {
			}
		};
		terminateExecutionAction.setDescription("Terminate Execution");
		terminateExecutionAction.setToolTipText("Terminate Execution");
		// terminateExecutionAction.setImageDescriptor(DebugPluginImages.getImageDescriptor(IInternalDebugUIConstants.IMG_LCL_TERMINATE));
		// terminateExecutionAction.setDisabledImageDescriptor(DebugPluginImages.getImageDescriptor(IInternalDebugUIConstants.IMG_DLCL_TERMINATE));

		// Add actions to the toobar manager associated with the form
		toolbarManager.add(removeFinishedAction);
		;
		toolbarManager.add(removeAllFinishedAction);
		toolbarManager.add(new Separator("Overview Expansion"));
		toolbarManager.add(expandAllAction);
		toolbarManager.add(collapseAllAction);
		toolbarManager.add(new Separator("Overview Details Behavior"));
		toolbarManager.add(lockDetailsAction);

		/*
		 * In the future, group by actions could be added here (based on search
		 * view look and feel) group by state, group by type, group by test
		 * suite, group by name, etc. Also the concept of execution mode such as
		 * run, debug and profile might make sense in future revisions.
		 */

		toolbarManager.add(new Separator("Execution Control"));
		toolbarManager.add(resumeExecutionAction);
		toolbarManager.add(suspendExecutionAction);
		toolbarManager.add(terminateExecutionAction);
		toolbarManager.add(new Separator());

		// Add additional action items to drop-down menu
		IMenuManager menuManager = this.getViewSite().getActionBars()
				.getMenuManager();
		menuManager.add(new Separator());

		/*
		 * Additional menu items such as sorting and filtering might be added in
		 * the future
		 */

		/*
		 * The previous details, next details, horizontal orientation and
		 * vertical orientation actions are added to the form itself and not the
		 * view by design.
		 */

	}

}
