/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: LogicalChangeUpdater.java,v 1.1 2005/03/18 16:39:35 jgout Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator;

import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.jface.viewers.TreeViewer;

/** Resource change listener used for the logical view of the test navigator
 * @author jgout
 * @since 4.0
 */
public class LogicalChangeUpdater implements IResourceChangeListener {

	private TestNavigator tn;
	
	public LogicalChangeUpdater(TestNavigator navigator) {
		this.tn = navigator;
	}

    class Refresher implements Runnable {
        private Object node;
        
        public Refresher(Object node) {
            this.node = node;
        }
        
        public void run() {
            ((TreeViewer)tn.getViewer()).refresh(node);
        }
    }
    
	public void resourceChanged(IResourceChangeEvent event) {
//		if(tn.getCurrentViewIndex() == TestNavigator.VIEW_ID_LOGICAL) {
//			IResourceDelta resDelta = event.getDelta();
//			//- get all projects affected by the current change
//			IResourceDelta[] affectedProjects = resDelta.getAffectedChildren();
//			for (int i = 0; i < affectedProjects.length; i++) {
//				IResourceDelta delta = affectedProjects[i];
//				IProject project = (IProject)delta.getResource();
//				List providers = TestNavigator.getTypeProviderManager().getTypeProviders(project);
//				for (Iterator it = providers.iterator(); it.hasNext();) {
//					final ITypeProviderProxyNode proxy = (ITypeProviderProxyNode) it.next();
//					int status = proxy.resourceChanged(delta);
//					if(status == IResourceChangedUpdateStatus.CHANGED) {
//						//- refresh the type provider tree in the UI thread
//                        Display.getDefault().syncExec(new Refresher(proxy));
// 					} else if(status == IResourceChangedUpdateStatus.REMOVED) {
// 					    //- the type provider proxy node is no longer necessary due to resource changed
//                       TestNavigator.getTypeProviderManager().removeProxy(project, proxy.getType());
//                       //- refresh the project
//                       Display.getDefault().syncExec(new Refresher(project));
//                    }
//				}
//			}
//		}
	}

}
