/**********************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TestDecoratingLabelProvider.java,v 1.9 2007/04/26 18:50:10 paules Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator;

import java.util.ArrayList;

import org.eclipse.core.resources.IFile;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.FileProxyNodeCache;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;

/**
 * @author jgout
 */
public class TestDecoratingLabelProvider extends DecoratingLabelProvider implements ILabelProviderListener{

	private final TestNavigator testNavigator;
	
	/**
	 * @param provider
	 * @param decorator
	 * @param testNavigator
	 */
	public TestDecoratingLabelProvider(ILabelProvider provider, ILabelDecorator decorator, TestNavigator testNavigator) {
		super(provider, decorator);
		this.testNavigator = testNavigator;
		if(decorator != null) {
			decorator.addListener(this);
		}
	}
	
	public void dispose() {
		ILabelDecorator decorator = getLabelDecorator();
		if(decorator != null) {
			decorator.removeListener(this);
		}
		super.dispose();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.ILabelProviderListener#labelProviderChanged(org.eclipse.jface.viewers.LabelProviderChangedEvent)
	 */
	public void labelProviderChanged(LabelProviderChangedEvent event) {
		Object [] elements = event.getElements();
        ArrayList others= new ArrayList();
		
		if (elements != null) {
            for (int i = 0; i < elements.length; i++) {
                Object elem = elements[i];
                if (elem instanceof IFile) {
                    //- need to check is there is not a proxy define for this file
                    IFile file = (IFile) elem;
                    if (file.exists()) {
                    	IProxyNode converted = FileProxyNodeCache.getInstance().getCachedProxy(file);
                    	if (converted != null) {
                    		if (testNavigator.getCurrentFileProxyManager().getParent(converted) != null) {
                    			others.add(converted);
                    		}
                    	}
                    }
                }
            }
            if (others.size() > 0) {
	            event = new LabelProviderChangedEvent((IBaseLabelProvider) event.getSource(), others.toArray());
	            fireLabelProviderChanged(event);
            }
        }
	}
}
