/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TestNavigatorFilterExtensionsManager.java,v 1.1 2005/03/18 16:39:35 jgout Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.navigator.IHyadesTestNavigatorFilter;

/** This class manages the org.eclipse.hyades.test.ui.testNavigatorFilter extensions.
 *  The way to access to the test navigator filters is <code>TestNavigator.getFiltersManager()</code>.
 * @author jgout
 * @since 4.0
 */
public class TestNavigatorFilterExtensionsManager {
	
	private List filters;

	public TestNavigatorFilterExtensionsManager() {
		filters = new LinkedList();

		IExtensionPoint extPoint = Platform.getExtensionRegistry().getExtensionPoint(UiPlugin.getID() + ".testNavigatorFilter"); //$NON-NLS-1$
		if (extPoint != null) {
			IConfigurationElement[] members = extPoint.getConfigurationElements();
			for (int i = 0; i < members.length; i++) {
				if (members[i].getName() != null) {
					//- save filter to delegate specific process
					try {
						IHyadesTestNavigatorFilter filter = (IHyadesTestNavigatorFilter) members[i].createExecutableExtension("class"); //$NON-NLS-1$
						addFilter(filter);
					} catch (CoreException e) {
						UiPlugin.logError(e);
					}
				}
			}
		}	
	}
	
	/**
	 * @param filter
	 */
	public void addFilter(IHyadesTestNavigatorFilter filter) {
		filters.add(filter);
	}

	/** Returns whether the given resource is visible in the test navigator (not filtered and handles).
	 * @param resource the resrouce to test.
	 * @return true if the resource is not filtered and handled by the navigator, false otherwise.
	 */
	public boolean isVisibleResource(IResource resource) {
		if(resource.getType() != IResource.FILE) {
			return !filter(resource);
		} else {
			String fileExtension = resource.getFileExtension();
			if (fileExtension != null) {
				return TestNavigator.getFileFactoryManager().isRegistered(fileExtension) && !filter(resource);
			}
			return false;
		}
	}
	
	public boolean filter(Object element) {
		if(element == null) return true;
		for (Iterator it = filters.iterator(); it.hasNext();) {
			IHyadesTestNavigatorFilter filter = (IHyadesTestNavigatorFilter) it.next();
			if (filter.isFiltered(element))
				return true;
		}
		return false;
	}

	public Object[] filterChildren(Object[] children) {
		if (children == null)
			return new Object[0];

		LinkedList res = new LinkedList();
		for (int i = 0; i < children.length; i++) {
			if (!filter(children[i]))
				res.add(children[i]);
		}
		return res.toArray();
	}

}
