/*******************************************************************************
 * Copyright (c) 2005, 2009 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TestNavigatorLabelProvider.java,v 1.5 2009/05/19 00:03:44 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.model.WorkbenchLabelProvider;

/** 
 * <p>Abstract label provider for the Test Navigator.</p>
 * 
 * 
 * @author  Jerome Gout
 * @author  Paul Slauenwhite
 * @version May 18, 2009
 * @since   February 1, 2005
 */
public class TestNavigatorLabelProvider implements ILabelProvider, ILabelProviderListener {
	
	private WorkbenchLabelProvider workbenchProvider = new WorkbenchLabelProvider();
	
	private List listeners;

	public TestNavigatorLabelProvider() {
		listeners = new LinkedList();
	}
	
	private IWorkbenchAdapter getWorkbenchAdapter(Object object) {
		IWorkbenchAdapter workbenchAdapter = (IWorkbenchAdapter) Platform.getAdapterManager().getAdapter(object, IWorkbenchAdapter.class);
		if (workbenchAdapter == this)
			return null;

		return workbenchAdapter;
	}
		
	public Image getImage(Object element) {
		if (element == null)
			return null;
		if (element instanceof IContainer) {
			return workbenchProvider.getImage(element);
		} else if (element instanceof IProxyNode) {
			Image image = ((IProxyNode) element).getImage();
			if (image == null) {
				// If the proxy does not provide an image, use the workbench adapter mechanism
				return workbenchProvider.getImage(element);
			}
			return image;
		}
		return null;
	}

	public String getText(Object element) {
		if (element == null)
			return ""; //$NON-NLS-1$
		if (element instanceof IContainer) {
			IWorkbenchAdapter workbenchAdapter = getWorkbenchAdapter(element);
			if (workbenchAdapter != null) {

				return workbenchAdapter.getLabel(element);
			}
		} else if (element instanceof IProxyNode) {
			String text = ((IProxyNode) element).getText();
            if(text != null && text.trim().length() > 0) {
                return text;
            } else {
                //- not displayable name, so replaces it by "<unmaned>"
                return '<'+TestNavigatorMessages.TEST_NAVIGATOR_UNNAMED_ELEMENT+'>';
            }
		}
		return ""; //$NON-NLS-1$
	}

	public void labelProviderChanged(LabelProviderChangedEvent event) {
		for (Iterator it = listeners.iterator(); it.hasNext();) {
			ILabelProviderListener listener = (ILabelProviderListener) it.next();
			listener.labelProviderChanged(event);
		}
	}

	public void addListener(ILabelProviderListener listener) {
		listeners.add(listener);
	}

	public void dispose() {
		workbenchProvider.dispose();
	}

	public boolean isLabelProperty(Object element, String property) {
		return false;
	}

	public void removeListener(ILabelProviderListener listener) {
		if (!listeners.remove(listener)) {
			UiPlugin.logInfo("Unable to remove listener '" + listener.toString()); //$NON-NLS-1$
		}
	}
}
