/*******************************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TestPerspectiveFactory.java,v 1.17 2008/03/13 18:18:13 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator;

import org.eclipse.hyades.internal.execution.recorder.ui.views.RecorderControlView;
import org.eclipse.hyades.test.ui.navigator.ITestNavigator;
import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveFactory;

/**
 * TPTP Test perspective.
 * 
 * 
 * @author  Paul E. Slauenwhite
 * @author  Marcelo Paternostro
 * @version March 13, 2008
 * @since   February 1, 2005
 */
public class TestPerspectiveFactory implements IPerspectiveFactory {

	public void createInitialLayout(IPageLayout layout) {

		String editorArea = layout.getEditorArea();

		//Top Left: Test Navigator view:
		IFolderLayout left = layout.createFolder("left", IPageLayout.LEFT, 0.25f, editorArea); //$NON-NLS-1$
		left.addView(ITestNavigator.ID);

		//Bottom Left: Properties view:
		IFolderLayout bottomLeft = layout.createFolder("bottomLeft", IPageLayout.BOTTOM, 0.65f, "left"); //$NON-NLS-1$ //$NON-NLS-2$
		bottomLeft.addView(IPageLayout.ID_PROP_SHEET);

		//Bottom: Recorder Control view placeholder:
		layout.addPlaceholder(RecorderControlView.ID, IPageLayout.BOTTOM, 0.65f, editorArea);

		//Show the views as shortcuts:
		layout.addShowViewShortcut(ITestNavigator.ID);
		layout.addShowViewShortcut(IPageLayout.ID_PROP_SHEET);
		layout.addShowViewShortcut(RecorderControlView.ID);
	}
}