/********************************************************************** 
 * Copyright (c) 2008, 2009 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * $Id: DeleteAction.java,v 1.4 2009/08/13 18:07:17 paules Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator.action;

import java.util.Iterator;
import java.util.LinkedList;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.navigator.action.resources.ActionMessages;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.DeleteRefactoring;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.DeleteRefactoringWizard;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.hyades.test.ui.navigator.actions.IProxyNodeDeleter;
import org.eclipse.hyades.ui.util.IDisposable;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.SelectionListenerAction;

/**
 * <code>Delete</code> action for the Test Navigator.
 * 
 * 
 * @author 	 Jerome Bozier
 * @author 	 Jerome Gout
 * @author 	 Paul E. Slauenwhite
 * @version  August 13, 2009
 * @since    March 20, 2008
 */
public class DeleteAction extends SelectionListenerAction implements IDisposable {
	private Shell shell;
	private LinkedList containers;
	private LinkedList proxies;
	
	public DeleteAction(Shell shell) {
		super(ActionMessages.DELETE_ACTION_NAME); 
		this.shell = shell;
		containers = new LinkedList();
		proxies = new LinkedList();
	}

	public void run() {
		if (! canActivate(shell))
			return;
		DeleteRefactoring refactoring = new DeleteRefactoring(containers, proxies);
		DeleteRefactoringWizard wizard = new DeleteRefactoringWizard(refactoring);
		wizard.setDefaultPageTitle(ActionMessages.DELETE_ACTION_NAME);
		wizard.setNeedsProgressMonitor(true);
		RefactoringWizardOpenOperation op = new RefactoringWizardOpenOperation(wizard);
		try {
			op.run(shell , ""); //$NON-NLS-1$
		} catch (InterruptedException e) {
			UiPlugin.logError(e);
		}
	}

	private boolean canActivate(Shell shell) {
		return EditorUtil.saveEditors(shell);
	}

	public void dispose() {
	}

	protected boolean updateSelection(IStructuredSelection selection) {
		boolean selOk = true;
		containers.clear();
		proxies.clear();
		for (Iterator it = selection.iterator(); it.hasNext() && selOk;) {
			Object o = it.next();
			if (o instanceof IContainer) {
				containers.add((IContainer) o);
			} else if (o instanceof IProxyNode) {
				IProxyNodeDeleter deleter = (IProxyNodeDeleter) ((IProxyNode) o).getAdapter(IProxyNodeDeleter.class);
				selOk &= deleter != null;
				if (deleter instanceof IProxyNode) {
					proxies.add(deleter);
				}
			} else {
				selOk = false;
			}
		}
		return selOk;
	}
	
	public boolean isApplicableForSelection() {

		if((!containers.isEmpty()) || (!proxies.isEmpty())){
			
			//Note: Cannot delete projects and other resources at the same time.
			boolean oneNotProject = (!proxies.isEmpty());
			boolean oneProject = false;
			Iterator containersIterator = containers.iterator();
			
			while(containersIterator.hasNext()) {
				
				IContainer cont = ((IContainer)(containersIterator.next()));
				
				if (cont instanceof IProject) {
					oneProject = true;
				} 
				else {
					oneNotProject = true;
				}
				
				if (oneNotProject && oneProject) {
					return false;
				}
			}
			
			return true;
		}
		
		return false;
	}
}
