/*******************************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ExecToggleEObjectChildrenAction.java,v 1.4 2008/01/21 17:19:39 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator.action;

import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.navigator.ExecutionNavigator;
import org.eclipse.hyades.test.ui.internal.util.ContextIds;
import org.eclipse.hyades.ui.internal.navigator.action.NavigatorAction;


/**
 * This action toggles whether the Test navigator should present the eObjects 
 * children.
 * 
 * @author marcelop
 * @since 0.2.0
 */
public class ExecToggleEObjectChildrenAction 
extends NavigatorAction
{
	/**
	 * Constructor for ToggleEObjectChildrenAction
	 * @param navigator
	 * @param label
	 */
	public ExecToggleEObjectChildrenAction(ExecutionNavigator execNavigator, String label)
	{
		super(execNavigator, label);
		setChecked(execNavigator.isShowingEObjectChildren());
		UiPlugin.getDefault().getWorkbench().getHelpSystem().setHelp(this, UiPlugin.getID() + ContextIds.EXEC_TOGGLE_ACT);												
	}

	/**
	 * @see org.eclipse.jface.action.IAction#run()
	 */
	public void run()
	{
		((ExecutionNavigator)getNavigator()).setShowingEObjectChildren(isChecked());
	}
}
