/*******************************************************************************
 * Copyright (c) 2005, 2009 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ExecutionNavigatorActionGroup.java,v 1.8 2009/04/23 22:17:40 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator.action;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.internal.model.ui.RemoveChildrenAction;
import org.eclipse.hyades.test.ui.internal.navigator.ExecutionNavigator;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.ui.internal.action.CollapseAllAction;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.hyades.ui.internal.navigator.ITreeNavigator;
import org.eclipse.hyades.ui.internal.navigator.action.FrameListActionGroup;
import org.eclipse.hyades.ui.internal.navigator.action.NavigatorActionGroup;
import org.eclipse.hyades.ui.internal.navigator.action.NavigatorSorterActionGroup;
import org.eclipse.hyades.ui.internal.navigator.action.ToggleLinkingAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.AddBookmarkAction;
import org.eclipse.ui.actions.AddTaskAction;
import org.eclipse.ui.actions.DeleteResourceAction;
import org.eclipse.ui.actions.WorkingSetFilterActionGroup;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.eclipse.ui.ide.IDEActionFactory;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.views.framelist.TreeFrame;
import org.eclipse.ui.views.navigator.ResourceNavigatorMessages;

/**
 * <p>Group action for the Test Navigator.</p>
 * 
 * <p>This implementation is based on the {@link org.eclipse.ui.views.navigator.MainActionGroup} class.</p>
 * 
 * 
 * @author      Paul E. Slauenwhite
 * @author      Marcelo Paternostro
 * @version     April 23, 2009
 * @since       February 1, 2005
 * @deprecated  As of TPTP 4.6, use {@link TestNavigatorActionGroup}.
 */
public class ExecutionNavigatorActionGroup 
extends NavigatorActionGroup
{
	protected ExecOpenEditorAction openAction;
	protected AddBookmarkAction addBookmarkAction;
	protected AddTaskAction addTaskAction;	
	protected PropertyDialogAction propertyDialogAction;
	protected CollapseAllAction collapseAllAction;
	protected ToggleLinkingAction toggleLinkingAction;
	protected ExecToggleFolderAction toggleFolderAction;
	protected ExecToggleEObjectChildrenAction toggleEObjectChildren;
	protected GenerateAction generateAction;	
	protected TestConnectionAction testConnectionAction;	
	protected RunAction runAction;	
	protected StopAction stopAction;
	protected SuspendAction suspendAction;
		
	protected DeleteResourceAction deleteResourceAction;
	protected RemoveChildrenAction deleteChildEObject;
	
	protected NavigatorSorterActionGroup sorterActionGroup;
	protected NewActionGroup newActionGroup;	
	protected WorkingSetFilterActionGroup workingSetFilterActionGroup;
	protected FrameListActionGroup frameListActionGroup;
//	protected Action filterAction;
	
	/**
	 * Constructor for NavigatorActionGroup
	 * @param execNavigator
	 */
	public ExecutionNavigatorActionGroup(ExecutionNavigator execNavigator)
	{
		super(execNavigator);
	}
	
	/**
	 * @see org.eclipse.ui.actions.ActionGroup#dispose()
	 */
	public void dispose()
	{
		newActionGroup.dispose();		
		workingSetFilterActionGroup.dispose();
		sorterActionGroup.dispose();
		frameListActionGroup.dispose();
		generateAction.dispose();
		testConnectionAction.dispose();
		runAction.dispose();
		stopAction.dispose();
		suspendAction.dispose();
		
		super.dispose();
	}

	/**
	 * @see org.eclipse.ui.actions.ActionGroup#setContext(org.eclipse.ui.actions.ActionContext)
	 */
	public void setContext(ActionContext context)
	{
		super.setContext(context);
		
		sorterActionGroup.setContext(context);
		newActionGroup.setContext(context);		
		workingSetFilterActionGroup.setContext(context);
		frameListActionGroup.setContext(context); 
	}

	/**
	 * @see org.eclipse.hyades.ui.internal.navigator.action.NavigatorActionGroup#createActions()
	 */
	protected void createActions()
	{
		super.createActions();
		Shell shell = getNavigator().getSite().getShell();
		
		openAction = new ExecOpenEditorAction((ExecutionNavigator)getNavigator(), UiPluginResourceBundle.ACT_OPEN); 
		addBookmarkAction = new AddBookmarkAction(shell);
		addTaskAction = new AddTaskAction(shell);
		propertyDialogAction = new PropertyDialogAction(shell, getNavigator().getViewer());	

		collapseAllAction = new CollapseAllAction(((ITreeNavigator)getNavigator()).getTreeViewer());
		collapseAllAction.useDefaultDecorators();

		toggleLinkingAction = new ToggleLinkingAction(getNavigator(), 
		        ResourceNavigatorMessages.getString("ToggleLinkingAction.text"));  //$NON-NLS-1$
		toggleLinkingAction.setToolTipText(ResourceNavigatorMessages.getString("ToggleLinkingAction.toolTip"));  //$NON-NLS-1$
		toggleLinkingAction.setImageDescriptor(getImageDescriptor("elcl16/synced.gif")); //$NON-NLS-1$
		toggleLinkingAction.setHoverImageDescriptor(getImageDescriptor("elcl16/synced.gif")); //$NON-NLS-1$

		toggleFolderAction = new ExecToggleFolderAction((ExecutionNavigator)getNavigator(), 
		        UiPluginResourceBundle.ACT_SHOW_FLD_TXT); 
		toggleFolderAction.setToolTipText(UiPluginResourceBundle.ACT_SHOW_FLD_DSC); 
		TestUIImages.INSTANCE.setImageDescriptors(toggleFolderAction, TestUIImages.ACT_SHOW_FOLDER);

		toggleEObjectChildren = new ExecToggleEObjectChildrenAction((ExecutionNavigator)getNavigator(),
		        UiPluginResourceBundle.ACT_SHOW_EOBJ_CH_TXT); 
		toggleEObjectChildren.setToolTipText(UiPluginResourceBundle.ACT_SHOW_EOBJ_CH_DSC); 
		TestUIImages.INSTANCE.setImageDescriptors(toggleEObjectChildren, TestUIImages.ACT_SHOW_EOBJECT_CHILDREN);

		ISharedImages images = PlatformUI.getWorkbench().getSharedImages();
		deleteResourceAction = new DeleteResourceAction(shell);
		deleteResourceAction.setDisabledImageDescriptor(images.getImageDescriptor(ISharedImages.IMG_TOOL_DELETE_DISABLED));
		deleteResourceAction.setImageDescriptor(images.getImageDescriptor(ISharedImages.IMG_TOOL_DELETE));		
		deleteResourceAction.setHoverImageDescriptor(images.getImageDescriptor(ISharedImages.IMG_TOOL_DELETE_HOVER));
		
		deleteChildEObject = new RemoveChildrenAction(true)
		{
			protected List saveResources(Set changedResources)
			{
				ExecutionNavigator execNavigator = (ExecutionNavigator)getNavigator();
				execNavigator.setMonitoringResourceChange(false);
				try
				{
					return super.saveResources(changedResources);
				}
				finally
				{
					execNavigator.setMonitoringResourceChange(true);
				}
			}
		};
		deleteChildEObject.setStructuredViewer(((ExecutionNavigator)getNavigator()).getViewer());
		deleteChildEObject.setShowErrorDialog(true);
		
		generateAction = new GenerateAction();	
		testConnectionAction = new TestConnectionAction();	
		runAction = new RunAction();	
		stopAction = new StopAction();		
		suspendAction = new SuspendAction();
	}

	/**
	 * @see org.eclipse.hyades.ui.internal.navigator.action.NavigatorActionGroup#createActionGroups()
	 */
	protected void createActionGroups()
	{
		super.createActionGroups();
		sorterActionGroup = new NavigatorSorterActionGroup(getNavigator());
		newActionGroup = new NewActionGroup((ExecutionNavigator)getNavigator());
		/*		
		filterAction = new Action(UiPlugin.getString("STR_FILTER_ACTION"))
		{
			public void run()
			{
				new ExecutionFilterDialog((ExecutionNavigator)getNavigator()).open();
			}
		};
*/
		IPropertyChangeListener workingSetUpdater = new IPropertyChangeListener()
		{
			public void propertyChange(PropertyChangeEvent event)
			{
				String property = event.getProperty();
				
				if (WorkingSetFilterActionGroup.CHANGE_WORKING_SET.equals(property))
				{
					INavigator navigator = getNavigator();
					Object newValue = event.getNewValue();
					
					if (newValue instanceof IWorkingSet)
					{	
						((ExecutionNavigator)navigator).setWorkingSet((IWorkingSet) newValue);
					}
					else if (newValue == null)
					{
						((ExecutionNavigator)navigator).setWorkingSet(null);
					}
				}
			}
		};
		workingSetFilterActionGroup = new WorkingSetFilterActionGroup(getNavigator().getViewer().getControl().getShell(), workingSetUpdater);
		workingSetFilterActionGroup.setWorkingSet(((ExecutionNavigator)getNavigator()).getWorkingSet());
		frameListActionGroup = new FrameListActionGroup((ExecutionNavigator)getNavigator());
	}

	/**
	 * @see org.eclipse.ui.actions.ActionGroup#fillContextMenu(org.eclipse.jface.action.IMenuManager)
	 */
	public void fillContextMenu(IMenuManager menu)
	{
		super.fillContextMenu(menu);
		IStructuredSelection structuredSelection = (IStructuredSelection)getContext().getSelection();
		IStructuredSelection resourceStructuredSelection = getResourceSelection(structuredSelection);

		newActionGroup.fillContextMenu(menu);
		frameListActionGroup.fillContextMenu(menu);
		
		openAction.selectionChanged(structuredSelection);
		if(openAction.isApplicableForSelection())
		{
			menu.add(openAction);
			menu.add(new Separator());			
		}
		
		generateAction.selectionChanged(structuredSelection);
		if(generateAction.isApplicableForSelection())
		{
			menu.add(generateAction);
		}

		testConnectionAction.selectionChanged(structuredSelection);
		if(testConnectionAction.isApplicableForSelection())
		{
			menu.add(testConnectionAction);
		}

		runAction.selectionChanged(structuredSelection);
		if(runAction.isApplicableForSelection())
		{
			menu.add(runAction);
		}
		
		stopAction.selectionChanged(structuredSelection);
		if(stopAction.isApplicableForSelection())
		{
			menu.add(stopAction);
			stopAction.setEnabled(stopAction.isApplicableForEnablement());
		}

		suspendAction.selectionChanged(structuredSelection);
		if(suspendAction.isApplicableForSelection())
		{
			menu.add(suspendAction);
			suspendAction.setEnabled(suspendAction.isApplicableForEnablement());
		}
		
		deleteResourceAction.setEnabled(false);		
		if(resourceStructuredSelection.size() == structuredSelection.size())
		{
			menu.add(new Separator());
			deleteResourceAction.selectionChanged(resourceStructuredSelection);
			menu.add(deleteResourceAction);
			menu.add(new Separator());
			
			addBookmarkAction.selectionChanged(resourceStructuredSelection);
			if(addBookmarkAction.isEnabled())
				menu.add(addBookmarkAction);
		}
		if(!deleteResourceAction.isEnabled())
		{
			menu.add(new Separator());
			deleteChildEObject.selectionChanged(structuredSelection);
			if(deleteChildEObject.isEnabled())
				menu.add(deleteChildEObject);
		}
		
		if(structuredSelection.size() == 1)
		{
			menu.add(new Separator());
			propertyDialogAction.selectionChanged(structuredSelection);
			if(propertyDialogAction.isApplicableForSelection())
				menu.add(propertyDialogAction);
		}
	}
		
	/**
	 * @see org.eclipse.ui.actions.ActionGroup#fillActionBars(org.eclipse.ui.IActionBars)
	 */
	public void fillActionBars(IActionBars actionBars)
	{
		actionBars.setGlobalActionHandler(ActionFactory.PROPERTIES.getId(),	propertyDialogAction);
		actionBars.setGlobalActionHandler(IDEActionFactory.BOOKMARK.getId(), addBookmarkAction);
		actionBars.setGlobalActionHandler(IDEActionFactory.ADD_TASK.getId(), addTaskAction);
		actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), deleteResourceAction);

		frameListActionGroup.fillActionBars(actionBars);
		workingSetFilterActionGroup.fillActionBars(actionBars);
		sorterActionGroup.fillActionBars(actionBars);
		
		super.fillActionBars(actionBars);		
		
		IToolBarManager toolBar = actionBars.getToolBarManager();
		toolBar.add(new Separator());
		toolBar.add(collapseAllAction);		
		toolBar.add(toggleLinkingAction);
	}
	
	/**
	 * @see org.eclipse.ui.actions.ActionGroup#updateActionBars()
	 */
	public void updateActionBars()
	{
		ExecutionNavigator execNavigator = (ExecutionNavigator)getNavigator();
		Object currentFrameInput = ((TreeFrame)execNavigator.getFrameList().getCurrentFrame()).getInput();
		toggleFolderAction.setEnabled((currentFrameInput == null) || (execNavigator.getInitialViewerInput() == currentFrameInput));
		toggleEObjectChildren.setEnabled((currentFrameInput == null) || (!(currentFrameInput instanceof EObject)));
		
		IStructuredSelection structuredSelection = (IStructuredSelection) getContext().getSelection();
		IStructuredSelection resourceStructuredSelection = getResourceSelection(structuredSelection);
		
		propertyDialogAction.setEnabled(structuredSelection.size() == 1);
		addBookmarkAction.selectionChanged(resourceStructuredSelection);
		deleteResourceAction.selectionChanged(resourceStructuredSelection);
		addTaskAction.selectionChanged(structuredSelection);	
	
		frameListActionGroup.updateActionBars();
		sorterActionGroup.updateActionBars();
		workingSetFilterActionGroup.updateActionBars();
	}
	
	/**
	 * @see org.eclipse.hyades.ui.internal.navigator.action.NavigatorActionGroup#runDefaultAction(org.eclipse.jface.viewers.IStructuredSelection)
	 */
	public void runDefaultAction(IStructuredSelection selection)
	{
		openAction.selectionChanged(selection);
		openAction.run();
	}
	
	/**
	 * @see org.eclipse.hyades.ui.internal.navigator.action.NavigatorActionGroup#handleKeyPressed(org.eclipse.swt.events.KeyEvent)
	 */
	public void handleKeyPressed(KeyEvent event)
	{
		if(event.character == SWT.DEL && (event.stateMask == 0))
		{
			if(deleteResourceAction.isEnabled())
				deleteResourceAction.run();
		}

		super.handleKeyPressed(event);
	}

	/**
	 * Returns an structured selection with resource elements based on the given
	 * structured selection.
	 * @param structuredSelection
	 * @return IStructuredSelection
	 * @see execNavigator#getFile(Object)
	 */
	protected IStructuredSelection getResourceSelection(IStructuredSelection structuredSelection)
	{
		ExecutionNavigator execNavigator = (ExecutionNavigator)getNavigator();
		List resources = new ArrayList();
		for(Iterator i = structuredSelection.iterator(); i.hasNext();)
		{
			Object object = i.next();
			if((object instanceof IResource) && (((IResource)object).getType() != IResource.FILE))
			{
				resources.add(object);
			}
			else
			{
				IFile file = execNavigator.getFile(object);
				if(file != null)
					resources.add(file);				
			}			
		}
		return new StructuredSelection(resources);
	}

	/**
	 * Returns the image descriptor from the eclipse UI plugin with the given relative 
	 * path.
	 * @return ImageDescriptor;
	 */
	protected ImageDescriptor getImageDescriptor(String relativePath)
	{
		String iconPath = "icons/full/"; //$NON-NLS-1$
		try
		{
			AbstractUIPlugin plugin = (AbstractUIPlugin) Platform.getPlugin(PlatformUI.PLUGIN_ID);
			URL installURL = plugin.getDescriptor().getInstallURL();
			URL url = new URL(installURL, iconPath + relativePath);
			return ImageDescriptor.createFromURL(url);
		}
		catch(MalformedURLException e)
		{
			return ImageDescriptor.getMissingImageDescriptor();
		}
	}	
}
