/********************************************************************** 
 * Copyright (c) 2008 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * $Id: FileAndFolderPaster.java,v 1.4 2008/11/19 18:10:42 bjerome Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator.action;

import java.util.LinkedList;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Path;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.navigator.action.resources.ActionMessages;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.FileProxyNodeCache;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.IPasterExtended;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.PasteRefactoring;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.PasteRefactoringWizard;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.part.ResourceTransfer;
/**
 * @author Jerome Bozier
 * @version November 5, 2008
 */
public class FileAndFolderPaster implements IPasterExtended {

	private LinkedList folders;
	private LinkedList proxies;
	private LinkedList externalFiles;
	private Clipboard clipboard;
	private Shell shell;

	public FileAndFolderPaster() {
		folders = new LinkedList();
		clipboard = null;
		proxies = new LinkedList();
		externalFiles = new LinkedList();
		shell = null;
	}
	
	public boolean isPasteAllowedFor(Clipboard clipboard, Object selection) {		
		return (selection instanceof IContainer);
	}

	public void setShell(Shell shell) {
		this.shell = shell;
	}
	
	private void sortClipboardElements(Object selection) {
		folders.clear();
		proxies.clear();
		externalFiles.clear();
		IContainer container = null;
		if (selection instanceof IContainer) {
			container = (IContainer)selection;
		}
		IResource [] res = getResourceFromClipboard(container);
		if (res == null) {
			return;
		}
		for (int i=0; i<res.length; i++) {
			if (res[i] instanceof IFile) {
				IProxyNode proxy = FileProxyNodeCache.getInstance().getProxy((IFile)res[i]);
				if (proxy != null) {
					proxies.add(proxy);
				}				
			} else if (res[i] instanceof IAdaptable) {
				IAdaptable a = (IAdaptable) res[i];
				Object o = a.getAdapter(IFolder.class);
				if(o != null) {
					folders.add((IFolder) o);
				}
			}
		}
	}
	
	
	private IResource [] getResourceFromClipboard(final IContainer container) {
		final IResource[][] clipboardData = new IResource[1][];
		shell.getDisplay().syncExec(new Runnable() {
			public void run() {
				//- clipboard must have resources or files
				ResourceTransfer resTransfer = ResourceTransfer.getInstance();
				// first case : copied inside eclipse
				clipboardData[0] = (IResource[]) clipboard.getContents(resTransfer);
				if (clipboardData[0] == null) {
					// second case : copied outside eclipse
					FileTransfer transfer = FileTransfer.getInstance();
					String[] res = (String [])clipboard.getContents(transfer);
					if (res != null) {
						IResource[] res2 = new IResource[res.length];
						for (int i=0; i<res.length; i++) {
							// basic case : resource already inside workspace
							Path path = new Path(res[i]);
							res2[i] = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(path);
							if (res2[i] == null) {
								// annoying case : resource not inside workspace => add it to external files to be deal separately
								externalFiles.add(res[i]);
							}
						}
						clipboardData[0] = res2;
					}
				}								
			}
		});
		return clipboardData[0];
	}
	
	private boolean canActivate(Shell shell) {
		return EditorUtil.saveEditors(shell);
	}
	
	public boolean performPaste(Clipboard clipboard, Object selection) {
		if (! canActivate(shell))
			return false;
		this.clipboard = clipboard;
		sortClipboardElements(selection);
		PasteRefactoring refactoring = new PasteRefactoring(folders,proxies,externalFiles);
		PasteRefactoringWizard wizard = new PasteRefactoringWizard(refactoring,selection);
		wizard.setDefaultPageTitle(ActionMessages.PASTE_ACTION_NAME);
		wizard.setNeedsProgressMonitor(true);
		RefactoringWizardOpenOperation op = new RefactoringWizardOpenOperation(wizard);
		try {
			op.run(shell , ""); //$NON-NLS-1$
		} catch (InterruptedException e) {
			UiPlugin.logError(e);
		}
		return true;
	}

}
