/**********************************************************************
 * Copyright (c) 2005, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: GenerateAction.java,v 1.10 2009/04/23 22:17:41 paules Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator.action;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.common.facades.behavioral.ITest;
import org.eclipse.hyades.models.common.facades.behavioral.ITestCase;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.test.core.util.EMFUtil;
import org.eclipse.hyades.test.ui.TestUIExtension;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.navigator.handlers.GenerateSourceCommandHandler;
import org.eclipse.hyades.test.ui.internal.util.ContextIds;
import org.eclipse.hyades.test.ui.navigator.ITestCaseProxyNode;
import org.eclipse.hyades.test.ui.navigator.ITestSuiteProxyNode;
import org.eclipse.hyades.ui.extension.IAssociationDescriptor;
import org.eclipse.hyades.ui.util.IDisposable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.PlatformUI;

/**
 * <p>GenerateAction.java</p>
 * 
 * 
 * @author      Paul E. Slauenwhite
 * @version     April 23, 2009
 * @since       February 1, 2005
 * @deprecated  As of TPTP 4.6, use {@link GenerateSourceCommandHandler}.
 */
public class GenerateAction 
extends Action implements IDisposable
{
	private IStructuredSelection structuredSelection;
	private IAssociationDescriptor wizardDescriptor;

	public GenerateAction()
	{
		super(UiPlugin.getString("GENERATE_SOURCE_SOURCE_MENU_LABEL"));  //$NON-NLS-1$
		UiPlugin.getDefault().getWorkbench().getHelpSystem().setHelp(this, UiPlugin.getID() + ContextIds.PREPARE_RUN_ACT);
	}
	
	public void dispose()
	{
		structuredSelection = null;
		wizardDescriptor = null;
	}

	protected IStructuredSelection getStructuredSelection()
	{
		return structuredSelection;
	}
	
	public void selectionChanged(IStructuredSelection structuredSelection)
	{
		wizardDescriptor = null;
		this.structuredSelection = structuredSelection;
	}

	protected IAssociationDescriptor getWizardDescriptor()
	{
		return wizardDescriptor;
	}

	public void run()
	{
		if(getWizardDescriptor() == null)
			return;
			
		IWorkbenchWizard workbenchWizard = (IWorkbenchWizard)getWizardDescriptor().createImplementationClassInstance();
		workbenchWizard.init(PlatformUI.getWorkbench(), getStructuredSelection());
		
		WizardDialog dialog = new WizardDialog(Display.getDefault().getActiveShell(), workbenchWizard);
		dialog.open();
		workbenchWizard.dispose();

		wizardDescriptor = null;
		structuredSelection = null;
	}

	public boolean isApplicableForSelection()
	{
		wizardDescriptor = null;
		if((structuredSelection == null) || (structuredSelection.size() != 1))
			return false;

		Object selection = structuredSelection.getFirstElement();
		if(selection instanceof ITest)
		{
			String type = ((ITest)selection).getType();
			if(type != null)
			{
				IAssociationDescriptor descriptor = null;
				if(selection instanceof ITestSuite)
					descriptor = TestUIExtension.getTestSuiteMappingRegistry().getAssociationMapping(UiPlugin.EP_GENERATE_WIZARDS).getDefaultAssociationDescriptor(type);
				else if(selection instanceof ITestCase)
					descriptor = TestUIExtension.getTestCaseMappingRegistry().getAssociationMapping(UiPlugin.EP_GENERATE_WIZARDS).getDefaultAssociationDescriptor(type);
					
				if((descriptor != null) && (descriptor.getImplementationClass() != null))
				{
					if(IWorkbenchWizard.class.isAssignableFrom(descriptor.getImplementationClass()))
					{
						wizardDescriptor = descriptor;
						
						IFile file = EMFUtil.getWorkspaceFile((EObject)selection);
						setEnabled(!file.isReadOnly());	
					}
				}
			}
		} else if(selection instanceof ITestSuiteProxyNode) {
			ITestSuiteProxyNode tsProxy = (ITestSuiteProxyNode) selection;
			String type = tsProxy.getType();
			IAssociationDescriptor descriptor = TestUIExtension.getTestSuiteMappingRegistry().getAssociationMapping(UiPlugin.EP_GENERATE_WIZARDS).getDefaultAssociationDescriptor(type);
			if((descriptor != null) && (descriptor.getImplementationClass() != null)) {
				if(IWorkbenchWizard.class.isAssignableFrom(descriptor.getImplementationClass())) {
					wizardDescriptor = descriptor;
				}
			}
		} else if(selection instanceof ITestCaseProxyNode) {
			ITestCaseProxyNode tcProxy = (ITestCaseProxyNode) selection;
			String type = tcProxy.getType();
			IAssociationDescriptor descriptor = TestUIExtension.getTestCaseMappingRegistry().getAssociationMapping(UiPlugin.EP_GENERATE_WIZARDS).getDefaultAssociationDescriptor(type);
			if((descriptor != null) && (descriptor.getImplementationClass() != null)) {
				if(IWorkbenchWizard.class.isAssignableFrom(descriptor.getImplementationClass())) {
					wizardDescriptor = descriptor;
				}
			}
		} 
		
		return (wizardDescriptor != null);
	}
}
