/********************************************************************** 
 * Copyright (c) 2008 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * $Id: MoveAction.java,v 1.3 2008/11/19 18:10:42 bjerome Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator.action;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.navigator.action.resources.ActionMessages;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.FileProxyNodeCache;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.MoveRefactoring;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.MoveRefactoringWizard;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.hyades.test.ui.navigator.actions.IProxyNodeMover;
import org.eclipse.hyades.ui.util.IDisposable;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.SelectionListenerAction;

/**
 * @author jgout
 * @author jbozier
 * @version November 5, 2008
 */
public class MoveAction extends SelectionListenerAction implements IDisposable {
	
	private Shell shell;
	private LinkedList folders;
	private LinkedList proxies;
	private boolean isResourceNav;
	
	public MoveAction(Shell shell) {
		super(ActionMessages.MOVE_ACTION_NAME); 
		this.shell = shell;
		folders = new LinkedList();
		proxies = new LinkedList();
		isResourceNav = false;
	}

	public void run() {
		if (! canActivate(shell))
			return;
		MoveRefactoring refactoring = new MoveRefactoring(folders, proxies);
		MoveRefactoringWizard wizard = new MoveRefactoringWizard(refactoring);
		wizard.setDefaultPageTitle(ActionMessages.MOVE_ACTION_NAME);
		wizard.setNeedsProgressMonitor(true);
		RefactoringWizardOpenOperation op = new RefactoringWizardOpenOperation(wizard);
		try {
			op.run(shell , ""); //$NON-NLS-1$
		} catch (InterruptedException e) {
			UiPlugin.logError(e);
		}
	}

	private boolean canActivate(Shell shell) {
		return EditorUtil.saveEditors(shell);
	}

	/**
	 * Selected elements should be only instances of IFile or IContainer (project/folder)
	 */
	private void sortSelectedElements() {
		folders.clear();
		proxies.clear();
		IStructuredSelection sel = getStructuredSelection();
		for (Iterator it = sel.iterator(); it.hasNext();) {
			Object o = it.next();
			if (o instanceof IProxyNode) {
				proxies.add(o);
			} else if (o instanceof IFile) {
				IProxyNode proxy = FileProxyNodeCache.getInstance().getProxy((IFile)o);
				if (proxy != null) {
					proxies.add(proxy);
				}				
			} else if (o instanceof IAdaptable) {
				IAdaptable a = (IAdaptable) o;
				o = a.getAdapter(IFolder.class);
				if(o != null) {
					folders.add((IFolder) o);
				}
			}
		}
	}

	public void dispose() {
	}

	public void selectionChanged(IStructuredSelection structuredSelection, boolean isResourceTestNav) {
		this.isResourceNav = isResourceTestNav;
		super.selectionChanged(structuredSelection);
		sortSelectedElements();
	}

	public boolean isApplicableForSelection() {
		//- Move action is only allowed for the resource view of the test navigator
		if(!isResourceNav) return false;
		if ((folders.size() == 0) && (!areProxiesMovable())) {
			return false;
		}
		if ((folders.isEmpty()) && (proxies.isEmpty())) {
			return false;
		}
		List allNames = new ArrayList();
		for (Iterator it = folders.iterator(); it.hasNext();) {
			String name = ((IFolder)(it.next())).getName();
			if (allNames.contains(name)) {
				return false;
			}
			allNames.add(name);
		}
		for (Iterator it = proxies.iterator(); it.hasNext();) {
			String name = ((IProxyNode)(it.next())).getUnderlyingResource().getName();
			if (allNames.contains(name)) {
				return false;
			}
			allNames.add(name);
		}		
		return true;
	}

	private boolean areProxiesMovable() {
		for (Iterator it = proxies.iterator(); it.hasNext();) {
			IProxyNode proxy = (IProxyNode)it.next();
			if ((proxy.getAdapter(IFile.class) == null) || (proxy.getAdapter(IProxyNodeMover.class) == null)) {
				return false;
			}
		}
		return true;
	}
}
