/*******************************************************************************
 * Copyright (c) 2005, 2010 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: NewActionGroup.java,v 1.8 2010/05/05 12:32:53 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator.action;

import java.util.Iterator;

import org.eclipse.hyades.test.ui.TestUIConstants;
import org.eclipse.hyades.test.ui.adapter.TestWorkbenchAdapter;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.ui.extension.INavigatorContribution;
import org.eclipse.hyades.ui.internal.logicalfolder.LogicalFolder;
import org.eclipse.hyades.ui.internal.navigator.TreeNavigator;
import org.eclipse.hyades.ui.internal.navigator.action.NavigatorActionGroup;
import org.eclipse.hyades.ui.internal.navigator.action.NewObjectAction;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchActionConstants;
import org.eclipse.ui.actions.NewWizardMenu;

/**
 * <p>Test Navigator action group for new actions.</p>
 * 
 * 
 * @author  Marcelo Paternostro
 * @author  Paul Slauenwhite
 * @version May 4, 2010
 * @since   February 1, 2005
 */
public class NewActionGroup extends NavigatorActionGroup {
	
	private NewObjectAction newTestSuiteAction;
	private NewObjectAction newDeploymentAction;
	private NewObjectAction newHyadesObjectAction;

	/**
	 * Constructor for CreateGroupAction
	 * @param testNavigator
	 */
	public NewActionGroup(TreeNavigator testNavigator)
	{
		super(testNavigator);
	}

	/**
	 * @see org.eclipse.hyades.ui.internal.navigator.action.NavigatorActionGroup#createActions()
	 */
	protected void createActions()
	{
		newTestSuiteAction = new NewObjectAction(getNavigator().getSite().getWorkbenchWindow());
		newTestSuiteAction.setText(UiPluginResourceBundle.LBL_TST_SUITE); 
		newTestSuiteAction.setToolTipText(newTestSuiteAction.getText());
		newTestSuiteAction.setWizardTitle(UiPluginResourceBundle.WIZ_TST_SUITE_TTL); 
		newTestSuiteAction.setWizardCategory(TestUIConstants.NEW_TEST_WIZARD_CATEGORY + "/testSuite"); //$NON-NLS-1$

		newDeploymentAction = new NewObjectAction(getNavigator().getSite().getWorkbenchWindow());
		newDeploymentAction.setText(UiPluginResourceBundle.LBL_DEPLOYMENT); 
		newDeploymentAction.setToolTipText(newDeploymentAction.getText());
		newDeploymentAction.setWizardTitle(UiPluginResourceBundle.WIZ_DEPLOY_TTL); 
		newDeploymentAction.setWizardCategory(TestUIConstants.NEW_TEST_WIZARD_CATEGORY + "/testElements"); //$NON-NLS-1$
		
		newHyadesObjectAction = new NewObjectAction(getNavigator().getSite().getWorkbenchWindow());
		newHyadesObjectAction.setText(UiPluginResourceBundle.WIZ_TST_OBJ_ACT); 
		newHyadesObjectAction.setWizardTitle(UiPluginResourceBundle.WIZ_TST_OBJ_TTL); 
		newHyadesObjectAction.setWizardCategory(TestUIConstants.NEW_TEST_WIZARD_CATEGORY); //$NON-NLS-1$
		newHyadesObjectAction.setToolTipText(newHyadesObjectAction.getText());
	}
	
	/**
	 * @see org.eclipse.ui.actions.ActionGroup#fillContextMenu(org.eclipse.jface.action.IMenuManager)
	 */
	public void fillContextMenu(IMenuManager menu)
	{
		IStructuredSelection structuredSelection = (IStructuredSelection)getContext().getSelection();

        
		if(getNavigator().isShowingFolders())
		{
			if(!hasLogicalFolder(structuredSelection))
			{
				MenuManager newMenu = new MenuManager(UiPluginResourceBundle.LBL_NEW, INavigatorContribution.GROUP_SUB_NEW); 
				menu.appendToGroup(INavigatorContribution.GROUP_NEW, newMenu);

				new NewWizardMenu(newMenu, getNavigator().getSite().getWorkbenchWindow(), false);

				newMenu.insert(0, new ActionContributionItem(newHyadesObjectAction));
				newMenu.insert(1,new Separator(IWorkbenchActionConstants.MB_ADDITIONS));
			}
		}
		else
		{
			if(structuredSelection.size() == 1)
			{
				Object selection = structuredSelection.getFirstElement();
				if(selection instanceof LogicalFolder)
				{
					LogicalFolder logicalFolder = (LogicalFolder)selection;
					if(logicalFolder.getParent() == null)
					{
						MenuManager newMenu = new MenuManager(UiPluginResourceBundle.LBL_NEW); 
						menu.appendToGroup(INavigatorContribution.GROUP_NEW, newMenu);

						String name = logicalFolder.getName();
						if(TestWorkbenchAdapter.TEST_SUITE_LOGICAL_FOLDER_NAME.equals(name))
							newMenu.add(newTestSuiteAction);

						else if(TestWorkbenchAdapter.DEPLOYMENT_LOGICAL_FOLDER_NAME.equals(name))
							newMenu.add(newDeploymentAction);
					}
				}
			}
		}
	}
	
	/**
	 * Returns <code>true</code> is there is one logical folder in the 
	 * given selection.
	 * @param structuredSelection
	 * @return boolean
	 */
	protected boolean hasLogicalFolder(IStructuredSelection structuredSelection)
	{
		for (Iterator i = structuredSelection.iterator(); i.hasNext();)
		{
			if(i.next() instanceof LogicalFolder)
				return true;
		}
		
		return false;
	}
}
