/*******************************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: OpenEditorAction.java,v 1.5 2008/01/21 17:19:39 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator.action;

import org.eclipse.core.resources.IFile;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.navigator.TestNavigator;
import org.eclipse.hyades.test.ui.internal.util.ContextIds;
import org.eclipse.hyades.test.ui.navigator.EditorIdFactory;
import org.eclipse.hyades.test.ui.navigator.IEditorIdFactory;
import org.eclipse.hyades.ui.internal.navigator.action.NavigatorAction;
import org.eclipse.hyades.ui.internal.util.UIUtil;
import org.eclipse.jface.viewers.IStructuredSelection;

/**
 * Open file editor action.
 * 
 * @author marcelop
 * @since 0.0.1 
 */
public class OpenEditorAction 
extends NavigatorAction
{
	// commented out for bugzilla #95329 - george.sebastian@ca.com
	//private static final String HYADES_EDITOR_ID_PREFIX = "org.eclipse.hyades."; //$NON-NLS-1$
	private IFile fileToOpen;
	
	/**
	 * Constructor for OpenAction
	 * @param navigator
	 * @param label
	 */
	public OpenEditorAction(TestNavigator testNavigator, String label)
	{
		super(testNavigator, label);
		UiPlugin.getDefault().getWorkbench().getHelpSystem().setHelp(this, UiPlugin.getID() + ContextIds.OPEN_EDITOR_ACT);												
	}
	
	/**
	 * @see org.eclipse.ui.actions.SelectionProviderAction#dispose()
	 */
	public void dispose()
	{
		fileToOpen = null;
		super.dispose();
	}	

	/**
	 * @see org.eclipse.jface.action.IAction#run()
	 */
	public void run()
	{
		//added for bugzilla #95329 - george.sebastian@ca.com
		IEditorIdFactory factory = EditorIdFactory.getInstance();
		UIUtil.openEditor(fileToOpen,factory.getEditorId(fileToOpen),true);
		//removed for bugzilla #95329 - george.sebastian@ca.com
		//UIUtil.openEditor(fileToOpen, HYADES_EDITOR_ID_PREFIX, true);
		
	}	
	
	/**
	 * @see org.eclipse.hyades.ui.internal.navigator.action.NavigatorAction#isApplicableForSelection()
	 */
	public boolean isApplicableForSelection()
	{
		return (fileToOpen != null);
	}
	
	/**
	 * @see org.eclipse.ui.actions.SelectionProviderAction#selectionChanged(org.eclipse.jface.viewers.IStructuredSelection)
	 */
	public void selectionChanged(IStructuredSelection structuredSelection)
	{
		if(structuredSelection.size() == 1)
			fileToOpen = ((TestNavigator)getNavigator()).getFile(structuredSelection.getFirstElement());
		else
			fileToOpen = null;
	}	
}
