/********************************************************************** 
 * Copyright (c) 2006 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * $Id$ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/ 
package org.eclipse.hyades.test.ui.internal.navigator.action;

import org.eclipse.core.resources.IFile;
import org.eclipse.hyades.test.ui.internal.navigator.TestNavigator;
import org.eclipse.hyades.test.ui.internal.navigator.TestNavigatorMessages;
import org.eclipse.hyades.ui.extension.INavigatorContribution;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.hyades.ui.internal.navigator.action.NavigatorActionGroup;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.actions.OpenWithMenu;

public class OpenWithActionGroup extends NavigatorActionGroup {

    public OpenWithActionGroup(INavigator navigator) {
        super(navigator);
    }

    public void fillContextMenu(IMenuManager menu) {
        IStructuredSelection selection = (IStructuredSelection)getContext().getSelection();
        if (selection.size() == 1) {
            MenuManager subMenu = new MenuManager(TestNavigatorMessages.OpenWithActionGroup_ActionLabel);
            IFile file = ((TestNavigator) getNavigator()).getFile(selection.getFirstElement());
            if (file != null) {
                subMenu.add(new OpenWithMenu(getNavigator().getSite().getPage(), file));
                menu.appendToGroup(INavigatorContribution.GROUP_OPEN, subMenu);
            }
        }
    }

}
