/*******************************************************************************
 * Copyright (c) 2009 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: 
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator.action;

import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Shell;

/**
 * <code>Select All</code> action for the Test Navigator.
 * 
 * 
 * @author 	 Jerome Bozier
 * @author 	 Paul E. Slauenwhite
 * @version  August 13, 2009
 * @since    July 27, 2009
 */
public class SelectAllAction extends Action {

	private TreeViewer viewer = null;
	
	protected SelectAllAction(final Shell shell, TreeViewer viewer) {
		
		super(UiPluginResourceBundle.command_SelectAll);

		this.viewer = viewer;
	}

	protected String getOperationMessage() {
		return UiPluginResourceBundle.command_SelectAll;
	}

	public boolean isApplicableForSelection() {
		return (viewer.getTree().getItemCount() > 0);
	}
	
	public void run() {
		
		if(isApplicableForSelection()){
			viewer.getTree().selectAll();
		}
	}
}
