/**********************************************************************
 * Copyright (c) 2008, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TestConnectionAction.java,v 1.2 2009/04/23 22:17:40 paules Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator.action;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.common.common.CMNNodeType;
import org.eclipse.hyades.test.ui.internal.navigator.handlers.TestConnectionCommandHandler;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.LocationProxyNode;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.test.ui.internal.util.TestUIUtilities;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;

/**
 * <p>Test connection action.</p>
 * 
 * 
 * @author      Paul E. Slauenwhite
 * @version     April 23, 2009
 * @since       April 18, 2008
 * @deprecated  As of TPTP 4.6, use {@link TestConnectionCommandHandler}.
 */
public class TestConnectionAction extends Action {

	private IStructuredSelection structuredSelection = null;

	/**
	 * Constructor for {@link TestConnectionAction}.
	 */
	public TestConnectionAction() {		
		super(UiPluginResourceBundle.TEST_CONNECTION_NAME);
	}

	public void dispose(){		
		structuredSelection = null;
	}
	
	public void selectionChanged(IStructuredSelection structuredSelection) {
		this.structuredSelection = structuredSelection;
	}

	public boolean isApplicableForSelection() {

		//Require single selection:
		if ((structuredSelection != null) && (structuredSelection.size() == 1)) {
		
			Object firstSelection = structuredSelection.getFirstElement();
		
			return ((firstSelection != null) && (firstSelection instanceof LocationProxyNode));
		}
		
		return false;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.jface.action.Action#run()
	 */
	public void run() {

		if (isApplicableForSelection()) {
		
			EObject locationEObject = ((LocationProxyNode)(structuredSelection.getFirstElement())).getEObject();

			if(locationEObject instanceof CMNNodeType){				
				TestUIUtilities.testConnection(((CMNNodeType)(locationEObject)));
			}
		}
	}
}
