/********************************************************************** 
 * Copyright (c) 2006, 2007 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html         
 *  
 * 
 * Contributors: 
 * pnedelec (IBM) - Initial API and implementation 
 **********************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator.action;

import org.eclipse.core.runtime.Assert;
import org.eclipse.hyades.test.ui.internal.navigator.TestNavigator;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.hyades.ui.internal.editor.HyadesEditorPart;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.hyades.ui.internal.navigator.action.NavigatorAction;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

/**
 * This action toggles whether this navigator links its selection to the active
 * editor.
 * 
 * @author pnedelec
 * @since 4.2
 */
public class ToggleLinkingAction extends NavigatorAction {
    /**
     * Constructor for ToggleLinkingAction
     * @param navigator
     * @param label
     */
    public ToggleLinkingAction(INavigator navigator, String label) {
        super(navigator, label);
        Assert.isLegal(navigator instanceof TestNavigator);
        setToolTipText(label);
        setChecked(navigator.isLinkingEnabled());
    }

    /**
     * @see org.eclipse.jface.action.IAction#run()
     */
    public void run() {
        INavigator navigator = getNavigator();
        boolean isChecked = isChecked();
        navigator.setLinkingEnabled(isChecked);
        if (!isChecked) return;
        //- Synchronize the test navigator with the input of the active editor
        IEditorPart editorPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (editorPart instanceof HyadesEditorPart) {
            Object elem = ((HyadesEditorPart) editorPart).getEditorObject();
            IProxyNode proxy = ((TestNavigator)navigator).getCurrentFileProxyManager().getCorrespondingProxy(elem);
            if (proxy != null) {
                navigator.selectReveal(new StructuredSelection(proxy));
            }
        }
    }
}
