/*******************************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ToggleViewAction.java,v 1.5 2007/04/25 14:46:51 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator.action;

import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.internal.navigator.TestNavigator;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.util.Assert;

/**
 * Action to switch between the different test navigator views.
 */
public class ToggleViewAction extends Action {
	
	private TestNavigator viewPart;
	private int viewerIndex;
		
	public ToggleViewAction(TestNavigator v, int viewerIndex) {
		super("", AS_RADIO_BUTTON); //$NON-NLS-1$
		if (viewerIndex == TestNavigator.VIEW_ID_RESOURCE) {
			setText(UiPluginResourceBundle.ToggleViewAction_resource_label); 
			setDescription(UiPluginResourceBundle.ToggleViewAction_resource_description); 
			setToolTipText(UiPluginResourceBundle.ToggleViewAction_resource_tooltip); 
			setImageDescriptor(TestUIImages.INSTANCE.getImageDescriptor("e", TestUIImages.RESOURCE_VIEW)); //$NON-NLS-1$

			//Set the ID of the action to the text label so it can be distinguished from the other action(s):
			setId(UiPluginResourceBundle.ToggleViewAction_resource_label);
		} else if (viewerIndex == TestNavigator.VIEW_ID_LOGICAL) {
			setText(UiPluginResourceBundle.ToggleViewAction_logical_label);
			setDescription(UiPluginResourceBundle.ToggleViewAction_logical_description); 
			setToolTipText(UiPluginResourceBundle.ToggleViewAction_logical_tooltip); 
			setImageDescriptor(TestUIImages.INSTANCE.getImageDescriptor("e", TestUIImages.LOGICAL_VIEW)); //$NON-NLS-1$

			//Set the ID of the action to the text label so it can be distinguished from the other action(s) on this toolbar:
			setId(UiPluginResourceBundle.ToggleViewAction_logical_label);
		} else {
			Assert.isTrue(false);
		}		
		
		viewPart= v;
		this.viewerIndex = viewerIndex;
	}
				
	public int getViewerIndex() {
		return viewerIndex;
	}

	public void run() {
		viewPart.setView(viewerIndex);
	}		
}