/**********************************************************************
 * Copyright (c) 2009, 2010 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: GenerateSourceCommandHandler.java,v 1.2 2010/05/20 17:45:30 paules Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator.handlers;

import java.util.List;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.hyades.test.ui.TestUIExtension;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.DefaultTestCaseProxyNode;
import org.eclipse.hyades.test.ui.navigator.DefaultTestSuiteProxyNode;
import org.eclipse.hyades.ui.extension.IAssociationDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

/**
 * <p>Handler for the generate source command (see
 * the <code>org.eclipse.ui.handlers</code> and 
 * <code>org.eclipse.ui.commands</code> extension points in this plug-in's
 * <code>plugin.xml</code> file).</p>
 *  
 * <p>The generate source command is used by the 
 * 'Generate Source' context menu (see <code>org.eclipse.ui.menus</code> extension point) 
 * and 'Alt+Shift+T, S' key binding (see <code>org.eclipse.ui.bindings</code> extension 
 * point).</p>
 * 
 * <p>Note: This handler only supports one or more {@link DefaultTestSuiteProxyNode} 
 * or {@link DefaultTestCaseProxyNode} selections in the Test Navigator, as declared 
 * in the implementation of the <code>org.eclipse.ui.handlers</code> extension point.</p>
 * 
 * 
 * @author  Paul E. Slauenwhite
 * @version May 20, 2010
 * @since   April 23, 2009
 */
public class GenerateSourceCommandHandler extends AbstractHandler{
	
	private IAssociationDescriptor wizardDescriptor;
	
	/* (non-Javadoc)
	 * @see org.eclipse.core.commands.AbstractHandler#setEnabled(java.lang.Object)
	 */
	public void setEnabled(Object evaluationContext) {
		
		wizardDescriptor = null;
		
		if(evaluationContext instanceof EvaluationContext){
		
			Object defaultVariable = ((EvaluationContext)(evaluationContext)).getDefaultVariable();
			
			if(defaultVariable instanceof List){
			
				List selections = ((List)(defaultVariable));
				
				if(selections.size() == 1){
					
					IAssociationDescriptor descriptor = null;
					Object selection = selections.get(0);
					
					if(selection instanceof DefaultTestSuiteProxyNode){
						descriptor = TestUIExtension.getTestSuiteMappingRegistry().getAssociationMapping(UiPlugin.EP_GENERATE_WIZARDS).getDefaultAssociationDescriptor(((DefaultTestSuiteProxyNode)(selection)).getType());
					}
					else if(selection instanceof DefaultTestCaseProxyNode){
						descriptor = TestUIExtension.getTestCaseMappingRegistry().getAssociationMapping(UiPlugin.EP_GENERATE_WIZARDS).getDefaultAssociationDescriptor(((DefaultTestCaseProxyNode)(selection)).getType());			
					}
					
					if((descriptor != null) && (descriptor.getImplementationClass() != null) && (IWorkbenchWizard.class.isAssignableFrom(descriptor.getImplementationClass()))) {
						wizardDescriptor = descriptor;
					}
				}
			}
		}
				
		setBaseEnabled(wizardDescriptor != null);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.core.commands.AbstractHandler#execute(org.eclipse.core.commands.ExecutionEvent)
	 */
	public Object execute(ExecutionEvent event) throws ExecutionException {

		if(wizardDescriptor != null){
			
			ISelection selection = HandlerUtil.getCurrentSelection(event); 
	
			if(selection != null){
	
				IStructuredSelection structuredSelection = null;
				
				if(selection instanceof IStructuredSelection){
					structuredSelection = ((IStructuredSelection)(selection));		
				}
				else{
					structuredSelection = new StructuredSelection(selection);
				}
				
				IWorkbenchWizard wizard = ((IWorkbenchWizard)(wizardDescriptor.createImplementationClassInstance()));
				wizard.init(PlatformUI.getWorkbench(), structuredSelection);
				
				WizardDialog wizardDialog = new WizardDialog(HandlerUtil.getActiveShell(event), wizard);
				wizardDialog.open();
				
				wizard.dispose();
			}	
			
			wizardDescriptor = null;
		}
		
		return null;
	}
}
