/**********************************************************************
 * Copyright (c) 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TestConnectionCommandHandler.java,v 1.1 2009/04/23 22:17:42 paules Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.common.common.CMNNodeType;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.LocationProxyNode;
import org.eclipse.hyades.test.ui.internal.util.TestUIUtilities;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;

/**
 * <p>Handler for the test connection command (see
 * the <code>org.eclipse.ui.handlers</code> and 
 * <code>org.eclipse.ui.commands</code> extension points in this plug-in's
 * <code>plugin.xml</code> file).</p>
 *  
 * <p>The test connection command is used by the 'Test Connection' context menu 
 * (see <code>org.eclipse.ui.menus</code> extension point) 
 * and 'Alt+Shift+T, T' key binding (see <code>org.eclipse.ui.bindings</code> extension 
 * point).</p>
 * 
 * <p>Note: This handler only supports a single {@link LocationProxyNode} selection 
 * in the Test Navigator, as declared in the implementation of the 
 * <code>org.eclipse.ui.handlers</code> extension point.</p>
 * 
 * 
 * @author  Paul E. Slauenwhite
 * @version April 23, 2009
 * @since   April 23, 2009
 */
public class TestConnectionCommandHandler extends AbstractHandler{

	/* (non-Javadoc)
	 * @see org.eclipse.core.commands.AbstractHandler#execute(org.eclipse.core.commands.ExecutionEvent)
	 */
	public Object execute(ExecutionEvent event) throws ExecutionException {

		ISelection selection = HandlerUtil.getCurrentSelection(event); 

		if(selection != null){

			IStructuredSelection structuredSelection = null;

			if(selection instanceof IStructuredSelection){
				structuredSelection = ((IStructuredSelection)(selection));		
			}
			else{
				structuredSelection = new StructuredSelection(selection);
			}

			EObject locationEObject = ((LocationProxyNode)(structuredSelection.getFirstElement())).getEObject();

			if(locationEObject instanceof CMNNodeType){				
				TestUIUtilities.testConnection(((CMNNodeType)(locationEObject)));
			}
		}	
		
		return null;
	}
}
