/*******************************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ArtifactProxyNode.java,v 1.6 2008/03/20 19:49:53 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator.proxy;

import java.util.Iterator;

import org.eclipse.hyades.models.common.configuration.CFGArtifact;
import org.eclipse.hyades.models.common.configuration.CFGClass;
import org.eclipse.hyades.test.ui.TestUIConstants;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.navigator.CMNNamedElementProxyNode;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.hyades.test.ui.navigator.IReferencerProxyNode;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMemento;

/**
 * @author jgout
 * @author Jerome Bozier
 * @version February 26, 2008
 * @since 3.2
 */
public class ArtifactProxyNode extends CMNNamedElementProxyNode {
	
	/**
	 * @param memento
	 * @param parent
	 */
	public ArtifactProxyNode(IMemento memento, Object parent) {
		super(memento, parent);
	}
	
	/**
	 * @param artifact
	 * @param parent
	 */
	public ArtifactProxyNode(CFGArtifact artifact, Object parent) {
		super(artifact, parent);
		//- add references on tets.
		for (Iterator it = artifact.getDeployableInstances().iterator(); it.hasNext();) {
			CFGClass test = (CFGClass) it.next();
			IProxyNode proxy = FileProxyNodeCache.getInstance().getCorrespondingProxy(test);
			if(proxy != null && proxy instanceof IReferencerProxyNode) {
				addBidirectionalReference("Artifact2Test", (IReferencerProxyNode) proxy, "Test2Artifact"); //$NON-NLS-1$ //$NON-NLS-2$
			}
		}
	}
	
	public Image getImage() {
		return TestUIImages.INSTANCE.getImage(TestUIImages.IMG_ARTIFACT);
	}
	
	public IProxyNode[] getChildren() {
		//- no children for this node
		return new IProxyNode[0];
	}
	
	public String getFactoryID() {
		return EMFResourceProxyFactory.ID;
	}
	
	public boolean saveState(IMemento memento) { 
		//- data to retrieve the correct object
		memento.putString(TestUIConstants.TAG_NODE_KIND, TestUIConstants.ARTIFACT_NODE);
		return super.saveState(memento);
	}
	
	protected String getNodeKind() {
		return TestUIConstants.ARTIFACT_NODE;
	}
}
