/*******************************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DatapoolProxyNode.java,v 1.7 2008/10/21 17:56:52 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator.proxy;

import org.eclipse.emf.common.util.URI;
import org.eclipse.hyades.models.common.datapool.DPLDatapool;
import org.eclipse.hyades.test.ui.TestUIConstants;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.navigator.CMNNamedElementProxyNode;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMemento;

/**
 * Proxy node for {@link DPLDatapool}s.
 * 
 * 
 * @author  Jerome Gout
 * @author  Jerome Bozier
 * @author  Paul Slauenwhite
 * @version October 21, 2008
 * @since   February 1, 2005
 */
public class DatapoolProxyNode extends CMNNamedElementProxyNode {

	/**
	 * Constructor to create a {@link DatapoolProxyNode} from a non-<code>null</code> textual name, URI, and parent
	 * and an optional description.
	 * 
	 * @param name The name of the {@link DatapoolProxyNode}.
	 * @param description The optional description of the {@link DatapoolProxyNode}, otherwise <code>null</code>.
	 * @param uri The {@link URI} of the {@link DatapoolProxyNode}.
	 * @param parent An existing object (possibly another proxy node) which is the parent of the newly created {@link DatapoolProxyNode} in the proxy node hierarchy.
	 */
	public DatapoolProxyNode(String name, String description, URI uri, Object parent) {
		super(name, description, uri, parent);
	}

	/**
	 * @param dp
	 * @param parent
	 */
	public DatapoolProxyNode(DPLDatapool dp, Object parent) {
		super(dp, parent);
	}

	/**
	 * @param memento
	 * @param parent
	 */
	public DatapoolProxyNode(IMemento memento, Object parent) {
		super(memento, parent);
	}

	public Image getImage() {
		return TestUIImages.INSTANCE.getImage(TestUIImages.IMG_DATAPOOL);
	}
	
	public IProxyNode[] getChildren() {
		//- no children for this node
		return new IProxyNode[0];
	}
	
	public String getFactoryID() {
		return EMFResourceProxyFactory.ID; 
	}
	
	public boolean saveState(IMemento memento) {
		//- data to retrieve the correct object 
		memento.putString(TestUIConstants.TAG_NODE_KIND, TestUIConstants.DATAPOOL_NODE);
		return super.saveState(memento);
	}
	
	protected String getNodeKind() {
		return TestUIConstants.DATAPOOL_NODE;
	}
}
