/*******************************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DefaultExecutionResultProxyNode.java,v 1.12 2008/07/09 11:33:14 bjerome Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator.proxy;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionEvent;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.ui.TestUIConstants;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.internal.model.EventUtil;
import org.eclipse.hyades.test.ui.navigator.IExecutionResultProxyNode;
import org.eclipse.hyades.test.ui.navigator.IPersistableProxyNode;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.hyades.test.ui.navigator.IReferencerProxyNode;
import org.eclipse.hyades.test.ui.navigator.ProxyNeedToBeRebuiltException;
import org.eclipse.hyades.test.ui.navigator.TypedElementProxyNode;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMemento;

/**
 * @author jgout
 * @author jcanches
 * @author Jerome Bozier
 * @version July 9, 2008
 * @since 3.2
 */
public class DefaultExecutionResultProxyNode extends TypedElementProxyNode implements IExecutionResultProxyNode, IPersistableProxyNode {
	
	private final static String TAG_VERDICT = "verdict"; //$NON-NLS-1$
	private final static String TAG_TIMESTAMP = "timestamp"; //$NON-NLS-1$
	
	private IProxyNode[] children;
    private int verdict;
    private long timestamp;
    private String cachedName;
	
	/**
	 * @param er
	 * @param parent
	 */
	public DefaultExecutionResultProxyNode(TPFExecutionResult er, Object parent) {
		super(er, parent);
		children = new IProxyNode[0];
		//- save the name of this element
		String name = er.getName();
		String testName = null; 
		TPFTest test = er.getTest();
		if(test != null) {
			testName = test.getName();
		}
		if (name != null) {
			if (testName != null && !testName.equals(name)) {
				name += " [" + testName + "]";  //$NON-NLS-1$//$NON-NLS-2$
			}
		} else {
			if (testName != null) {
				name = testName;
			}
		}
        if((er.getTest() != null)/* && (((er.getTest()).getName()) != null)*/) {
            if (test instanceof TPFTestSuite) {
                if (er.getExecutionHistory().getExecutionEvents()!=null && er.getExecutionHistory().getExecutionEvents().size()>0) {
                	timestamp = ((TPFExecutionEvent)er.getExecutionHistory().getExecutionEvents().get(0)).getTimestamp();
                    String dateStamp = EventUtil.getTime(timestamp);
                    name += " ["+dateStamp+"]";  //$NON-NLS-1$//$NON-NLS-2$
                }
                //- add the link between execution and test suite.
                IProxyNode proxy = FileProxyNodeCache.getInstance().getCorrespondingProxy(test);
                if (proxy != null) {
                	addBidirectionalReference("TestLog2TestSuite", (IReferencerProxyNode)proxy, "TestSuite2TestLog");  //$NON-NLS-1$//$NON-NLS-2$
				}
            } else {
                name += " [" + (er.getTest()).getName() + "]"; //$NON-NLS-1$ //$NON-NLS-2$
            }
		}
        cachedName = name;
        verdict = er.getVerdict().getValue();
	}
	
	public DefaultExecutionResultProxyNode(IMemento memento, Object parent) {
		super(memento, parent);
        Integer v = memento.getInteger(TAG_VERDICT);
        String l = memento.getString(TAG_TIMESTAMP);
        if(v == null || l == null) {
            //- old memento, we need to rebuild the proxy from execution file
            throw new ProxyNeedToBeRebuiltException();
        } else {
            verdict = v.intValue();
        }
        try {
        	timestamp = Long.parseLong(l);
        } catch (NumberFormatException e) {
        	timestamp = 0L;
        }
        children = new IProxyNode[0];
        cachedName = this.getName();
	}
	
	public String getText() {
		if (timestamp != 0L) {
			if (cachedName == null) {
				String dateStamp = EventUtil.getTime(timestamp);
				cachedName = super.getText() + " ["+dateStamp+"]";  //$NON-NLS-1$//$NON-NLS-2$
			}
			return cachedName;
		}
		return super.getText();
	}
	
	public Image getImage() {
		return TestUIImages.INSTANCE.getImage(TestUIImages.IMG_EXECUTION);
	}
	
	public IProxyNode[] getChildren() {
		return children;
	}
		
	public TPFExecutionResult getExecutionResult() {
		EObject exec = super.getEObject();
		if (exec instanceof TPFExecutionResult) {
			return (TPFExecutionResult) exec;
		} else {
			return null;
		}
	}

    public int getVerdict() {
        return verdict;
    }

    protected String getNodeKind() {
    	return TestUIConstants.EXECUTION_RESULT_NODE;
    }
    
    public String getFactoryID() {
        return EMFResourceProxyFactory.ID; 
    }
 
    public boolean saveState(IMemento memento) {
        //- data to retrieve the correct object 
        memento.putInteger(TAG_VERDICT, getVerdict());
        memento.putString(TAG_TIMESTAMP, Long.toString(timestamp));
        return super.saveState(memento);
    }
}
