/*******************************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DefaultTestCaseProxyNode.java,v 1.9 2008/10/23 10:24:01 bjerome Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator.proxy;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.common.testprofile.TPFTestCase;
import org.eclipse.hyades.test.ui.TestUIConstants;
import org.eclipse.hyades.test.ui.TestUIExtension;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.navigator.IPersistableProxyNode;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.hyades.test.ui.navigator.ITestCaseProxyNode;
import org.eclipse.hyades.test.ui.navigator.TypedElementProxyNode;
import org.eclipse.hyades.ui.extension.IAssociationConstants;
import org.eclipse.hyades.ui.extension.IAssociationDescriptor;
import org.eclipse.hyades.ui.extension.IAssociationMapping;
import org.eclipse.hyades.ui.internal.extension.AssociationMappingRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMemento;

/**
 * @author jgout
 * @author Jerome Bozier
 * @version October 21, 2008
 */
public class DefaultTestCaseProxyNode extends TypedElementProxyNode implements ITestCaseProxyNode, IPersistableProxyNode {

	private IAssociationDescriptor descriptor;

	/**
	 * @param tc
	 * @param parent
	 */
	public DefaultTestCaseProxyNode(TPFTestCase tc, Object parent) {
		super(tc, parent);
		AssociationMappingRegistry registry = (AssociationMappingRegistry)TestUIExtension.getTestCaseMappingRegistry();
		IAssociationMapping associationMapping = registry.getAssociationMapping(IAssociationConstants.EP_TYPE_DESCRIPTIONS);
		if (associationMapping == null) {
			descriptor = null;
		} else {
			descriptor = associationMapping.getDefaultAssociationDescriptor(tc.getType());
		}
	}

	public DefaultTestCaseProxyNode(IMemento memento, Object parent) {
		super(memento, parent);
		AssociationMappingRegistry registry = (AssociationMappingRegistry)TestUIExtension.getTestCaseMappingRegistry();
		IAssociationMapping associationMapping = registry.getAssociationMapping(IAssociationConstants.EP_TYPE_DESCRIPTIONS);
		if (associationMapping == null) {
			descriptor = null;
		} else {
			descriptor = associationMapping.getDefaultAssociationDescriptor(getType());
		}
	}
	
	public Image getImage() {
		if(descriptor != null) {
			return descriptor.getImage();
		} else {
			//- the type of this element wasn't registered by any extension (hyades.ui.typeDescriptions)
			return TestUIImages.INSTANCE.getImage(TestUIImages.IMG_TEST_CASE);
		}
	}

	public IProxyNode[] getChildren() {
		//- no children for a test case node
		return new IProxyNode[0];
	}
	
	public TPFTestCase getTestCase() {
		EObject tc = super.getEObject();
		if (tc instanceof TPFTestCase) {
			return (TPFTestCase) tc;
		} else {
			return null;
		}
	}
	
	public String getFactoryID() {
		return EMFResourceProxyFactory.ID; 
	}
	
	public boolean saveState(IMemento memento) {
		//- data to retrieve the correct object 
		memento.putString(TestUIConstants.TAG_NODE_KIND, TestUIConstants.TESTCASE_NODE);
		return super.saveState(memento);
	}
		
	protected String getNodeKind() {
		return TestUIConstants.TESTCASE_NODE;
	}
}
