/*******************************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DefaultTypeProviderProxyNode.java,v 1.11 2007/06/01 14:52:02 jgout Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator.proxy;

import java.util.LinkedList;
import java.util.List;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.hyades.models.common.util.ICommonConstants;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.navigator.TestNavigator;
import org.eclipse.hyades.test.ui.navigator.IFileProxyManager;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.hyades.test.ui.navigator.ITestFolderContentValidator;
import org.eclipse.hyades.test.ui.navigator.ITypeProviderProxyNode;
import org.eclipse.hyades.test.ui.navigator.ITypedElementProxyNode;
import org.eclipse.hyades.test.ui.navigator.TestFolderProxyNode;
import org.eclipse.swt.graphics.Image;

/** 
 * This class is the default proxy node to group all test assets of a given type.
 * This node is created by the default type provider factory. 
 * A test folder only shows test assets of a specified type.
 * 
 * @author jgout
 * @since 4.0
 * @see org.eclipse.hyades.test.ui.internal.navigator.proxy.DefaultTypeProvider
 */
public class DefaultTypeProviderProxyNode extends TestFolderProxyNode implements ITypeProviderProxyNode {

	private String type;
	private String name;
    private String imageKey;

	public static class DefaultTestFolderContentValidator implements ITestFolderContentValidator {
		private String type;
        private List extensions = new LinkedList();

		public DefaultTestFolderContentValidator(String type) {
			this.type = type;
            extensions.add(ICommonConstants.TEST_SUITE_FILE_EXTENSION);
            extensions.add(ICommonConstants.EXECUTION_FILE_EXTENSION);
            extensions.add(ICommonConstants.TEST_COMPONENT_EXTENSION);
		}
        
		public boolean isFileOk(IFile file) {
			return extensions.contains(file.getFileExtension());
		}

		public boolean isProxyOk(IProxyNode node) {
			if(node instanceof ITypedElementProxyNode) {
				return type.equals(((ITypedElementProxyNode)node).getType());
			}
			return false;
		}
	}
   
	public DefaultTypeProviderProxyNode(IProject project, ITestFolderContentValidator customValidator, IFileProxyManager fileProxyManager, String type, Object parent) {
        super(project, customValidator, fileProxyManager, false,  parent);
        this.name = TestNavigator.getTypeProviderManager().getNameFor(type);
        if(this.name == null || this.name.length() == 0) {
            this.name = TestNavigator.getRegisteredTypeName(type);
        }
        this.type = type;
        this.imageKey = TestNavigator.getTypeProviderManager().getImageKeyFor(type);
	}
	
	public DefaultTypeProviderProxyNode(IProject project, IFileProxyManager fileProxyManager, String type, Object parent) {
		this(project, new DefaultTestFolderContentValidator(type), fileProxyManager, type, parent);
	}
	
	public String getText() {
		return this.name;
	}
	
    public Image getImage() {
        if(this.imageKey == null || this.imageKey.length() == 0) {
            return super.getImage();
        } else {
            return UiPlugin.getInstance().getImageRegistry().get(this.imageKey);
        }
    }
    
	public boolean isApplicableFor() {
		//- A type provider proxy node can not be renamed
		return false;
	}

	public IProxyNode resourceChanged(IResourceDelta delta) {
		return super.resourceChanged(delta);
	}

    /**
     * @return Returns the type.
     */
    public String getType() {
        return type;
    }

	public IResource getCorrespondingResource() {
		return null;
	}
}
