/*******************************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DeploymentProxyNode.java,v 1.7 2008/04/22 19:25:51 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator.proxy;

import java.util.Iterator;

import org.eclipse.hyades.models.common.configuration.CFGArtifact;
import org.eclipse.hyades.models.common.configuration.CFGLocation;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;
import org.eclipse.hyades.test.ui.TestUIConstants;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.navigator.CMNNamedElementProxyNode;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.hyades.test.ui.navigator.IReferencerProxyNode;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMemento;

/**
 * @author jgout
 * @author Jerome Bozier
 * @version February 26, 2008
 * @since 3.2
 */
public class DeploymentProxyNode extends CMNNamedElementProxyNode {
	/**
	 * @param deploy
	 * @param parent
	 */
	public DeploymentProxyNode(TPFDeployment deploy, Object parent) {
		super(deploy, parent);
		for (Iterator it = deploy.getArtifacts().iterator(); it.hasNext();) {
			IProxyNode artifact = FileProxyNodeCache.getInstance().getCorrespondingProxy( (CFGArtifact)it.next());
			if(artifact != null) {
				addBidirectionalReference("Deploy2Artifact", (IReferencerProxyNode) artifact, "Artifact2Deploy");  //$NON-NLS-1$//$NON-NLS-2$
			}
		}
		for (Iterator it = deploy.getLocations().iterator(); it.hasNext();) {
			IProxyNode location = FileProxyNodeCache.getInstance().getCorrespondingProxy((CFGLocation)it.next());
			if(location != null) {
				addBidirectionalReference("Deploy2Location", (IReferencerProxyNode) location, "Location2Deploy"); //$NON-NLS-1$ //$NON-NLS-2$
			}
		}
		for (Iterator it = deploy.getRefLocations().iterator(); it.hasNext();) {
			IProxyNode location = FileProxyNodeCache.getInstance().getCorrespondingProxy((CFGLocation)it.next());
			if(location != null) {
				addBidirectionalReference("Deploy2Location", (IReferencerProxyNode) location, "Location2Deploy"); //$NON-NLS-1$ //$NON-NLS-2$
			}
		}
	}

	/**
	 * @param memento
	 * @param parent
	 */
	public DeploymentProxyNode(IMemento memento, Object parent) {
		super(memento, parent);
	}

	public Image getImage() {
		return TestUIImages.INSTANCE.getImage(TestUIImages.IMG_DEPLOYMENT);
	}
	
	public IProxyNode[] getChildren() {
		//- no children for this node
		return new IProxyNode[0];
	}
	
	public String getFactoryID() {
		return EMFResourceProxyFactory.ID; 
	}
	
	public boolean saveState(IMemento memento) {
		//- data to retrieve the correct object 
		memento.putString(TestUIConstants.TAG_NODE_KIND, TestUIConstants.DEPLOY_NODE);
		return super.saveState(memento);	
	}
	
	protected String getNodeKind() {
    	return TestUIConstants.DEPLOY_NODE;
    }
}
