/*******************************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: EMFResourceProxyNode.java,v 1.8 2007/06/01 14:52:02 jgout Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator.proxy;

import java.util.LinkedList;
import java.util.List;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.test.ui.TestUIConstants;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.navigator.FileProxyNode;
import org.eclipse.hyades.test.ui.navigator.HyadesProxyNodeFactory;
import org.eclipse.hyades.test.ui.navigator.IPersistableProxyNode;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.ui.IMemento;

/**
 * @author jgout
 * @since 3.2
 */
public abstract class EMFResourceProxyNode extends FileProxyNode implements IPersistableProxyNode {

	private static final String TAG_NAME = "name"; //$NON-NLS-1$
	
	private List children;
	private String name;
	
	/**
	 * @param file
	 * @param resource
	 */
	public EMFResourceProxyNode(IFile file, Resource resource) {
		super(file);
		EObject[] eObjects;
		children = new LinkedList();
		
		eObjects = (EObject[]) resource.getContents().toArray(new EObject[resource.getContents().size()]); 
		IProxyNode child = null;
		for (int i = 0; i < eObjects.length; i++) {
			child = HyadesProxyNodeFactory.getInstance().create(eObjects[i], this);
			if(child != null) {
				children.add(child);
			}
		}
		name = file.getName();
		name = name.substring(0, name.length()-(file.getFileExtension().length()+1));
	}

	public EMFResourceProxyNode(IFile file, IMemento rootMemento) {
		super(file);
		this.name = rootMemento.getString(TAG_NAME);
		children = new LinkedList();
		IProxyNode child = null;
		IMemento[] childrenState = rootMemento.getChildren(TestUIConstants.TAG_CHILD);
		for (int i = 0; i < childrenState.length; i++) {
			IMemento memento = childrenState[i];
			child = HyadesProxyNodeFactory.getInstance().recreate(memento, this);
			if(child != null) {
				children.add(child);
			}
		}
	}
	
	public IProxyNode[] getChildren() {
		return (IProxyNode[]) children.toArray(new IProxyNode[children.size()]);
	}
	
	public String getText() {
		return name;
	}

	protected boolean saveChildState(IMemento memento, IProxyNode child) {
		if (child instanceof IPersistableProxyNode) {
			IPersistableProxyNode proxy = (IPersistableProxyNode) child;
			//- create a sub memento to store the child proxy node
			IMemento childMemento = memento.createChild(TestUIConstants.TAG_CHILD);
			return proxy.saveState(childMemento);
		} else {
			UiPlugin.logError("Child proxy node: "+child.getText()+" should be persistable"); //$NON-NLS-1$ //$NON-NLS-2$
			return false;
		}
	}
	
	public String getFactoryID() {
		return EMFResourceProxyFactory.ID;
	}
	
	public boolean saveState(IMemento memento) {
		memento.putString(TestUIConstants.TAG_NODE_KIND, getNodeKind());
		memento.putString(TAG_NAME, getText());
		IProxyNode [] children = getChildren();
		for (int i = 0; i < children.length; i++) {
			if(!saveChildState(memento, children[i])) {
				return false;
			}
		}
		return true;
	}
	
	protected abstract String getNodeKind();

}
