/**********************************************************************
 * Copyright (c) 2010 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: FileProxyNodeCacheMemoryEventHandler.java,v 1.2 2010/03/17 14:44:15 paules Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator.proxy;

import org.eclipse.equinox.events.MemoryEventConstants;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

/**
 * <p>Implementation of the <a href="https://bugs.eclipse.org/bugs/show_bug.cgi?id=284061">Cache Coordinator</a> for 
 * {@link FileProxyNodeCache#clearCache() clearing} the {@link FileProxyNodeCache} of its cached {@link IProxyNode}(s) when the memory consumption is 
 * {@link MemoryEventConstants#TOPIC_CRITICAL critically low}.</p>
 * 
 * <p>The file proxy node cache memory event handler in register in the {@link UiPlugin#start(org.osgi.framework.BundleContext)}
 * method.</p>
 * 
 * <p><b>Note:</b> Although this file proxy node cache memory event handler is efficient, 
 * opening the Test Navigator will cause all {@link IProxyNode}(s) to be rebuilt.</p>
 * 
 * 
 * @author  Paul Slauenwhite
 * @version March 17, 2010
 * @since   March 3, 2010
 * @see     EventHandler
 * @see     FileProxyNodeCache
 */
public class FileProxyNodeCacheMemoryEventHandler implements EventHandler{

	/* (non-Javadoc)
	 * @see org.osgi.service.event.EventHandler#handleEvent(org.osgi.service.event.Event)
	 */
	public void handleEvent(Event event) {
		
		if(MemoryEventConstants.TOPIC_CRITICAL.equals(event.getTopic())){
			FileProxyNodeCache.getInstance().clearCache();
		}
	}
}
