/*******************************************************************************
 * Copyright (c) 2006, 2010 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IFileProxyPersister.java,v 1.4 2010/03/19 18:21:48 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator.proxy;

import org.eclipse.core.resources.IFile;
import org.eclipse.hyades.test.ui.navigator.IPersistableProxyNode;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;

/**
 * <p>Interface for saving {@link IPersistableProxyNode}s and loading {@link IProxyNode}s.</p>
 * 
 * 
 * @author  Jerome Gout
 * @author  Jerome Bozier
 * @author  Julien Canches
 * @author  Paul Slauenwhite
 * @version March 19, 2010
 * @since   September 28, 2006
 */
public interface IFileProxyPersister {

	/**
	 * <p>Loads the {@link IProxyNode} for the {@link IFile} from the file system.</p>
	 * 
	 * @param file The {@link IFile} associated with the loaded {@link IProxyNode}.
	 * @return The {@link IProxyNode} loaded for the {@link IFile} from the file system.
	 */
	public IProxyNode loadProxy(IFile file);

	/**
	 * <p>Saves the {@link IPersistableProxyNode} for the {@link IFile} to the file system.</p>
	 * 
	 * @param file The {@link IFile} associated with the saved {@link IPersistableProxyNode}.
	 * @param proxyNode The {@link IPersistableProxyNode} to be saved to the file system.
	 * @throws Exception An error occurred when saving the {@link IPersistableProxyNode} to the file system.
	 */
	public void saveProxy(IFile file, IPersistableProxyNode proxyNode) throws Exception;
}