/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IFilter.java,v 1.3 2006/10/27 18:59:09 paules Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator.proxy;

import org.eclipse.hyades.test.ui.navigator.IProxyNode;

/**
 * A basic interface to filter elements in a Test Provider.
 * 
 * @author pnedelec
 * @since 4.0.0
 */
public interface IFilter {
    
    /**
     * @param type A test type
     * @return true if the root node associated to the type should be displayed
     */
    public boolean satisfies(String type);
    
    /**
     * @param node A proxy node
     * @return true if the proxy node should be displayed
     */
    public boolean satisfies(IProxyNode node);

    /**
     * 
     * @param node A proxy node
     * @return Whether the children of node should be displayed, if they satisfy this
     * filter. If false, no child of this node is displayed.
     */
    public boolean satisfiesChildren(IProxyNode node);
}
