/********************************************************************** 
 * Copyright (c) 2008 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * $Id: IProxyNodeAdapterFactory.java,v 1.1 2008/03/20 19:49:53 paules Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator.proxy;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.DefaultProxyNodeDeleter;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.hyades.test.ui.navigator.actions.IProxyNodeDeleter;

/**
 * @author jgout
 * @version February 26, 2008
 */
public class IProxyNodeAdapterFactory implements IAdapterFactory {

	public Object getAdapter(Object adaptableObject, Class adapterType) {
		if (adaptableObject instanceof IProxyNode && IProxyNodeDeleter.class.equals(adapterType)) {
			IProxyNode proxy = (IProxyNode) adaptableObject;
			if(proxy.getAdapter(IFile.class) != null) {
				return new DefaultProxyNodeDeleter(proxy);
			}
		}
		return null;
	}

	public Class[] getAdapterList() {
		return new Class[] { IProxyNodeDeleter.class };
	}

}
