/*******************************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: LocationProxyNode.java,v 1.6 2008/03/20 19:49:54 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator.proxy;

import org.eclipse.hyades.models.common.configuration.CFGLocation;
import org.eclipse.hyades.test.ui.TestUIConstants;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.navigator.CMNNamedElementProxyNode;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMemento;

/**
 * @author jgout
 * @version February 26, 2008
 * @since 3.2
 */
public class LocationProxyNode extends CMNNamedElementProxyNode {
	/**
	 * @param loc
	 * @param parent
	 */
	public LocationProxyNode(CFGLocation loc, Object parent) {
		super(loc, parent);
	}

	/**
	 * @param memento
	 * @param parent
	 */
	public LocationProxyNode(IMemento memento, Object parent) {
		super(memento, parent);
	}

	public Image getImage() {
		return TestUIImages.INSTANCE.getImage(TestUIImages.IMG_LOCATION);
	}
	
	public IProxyNode[] getChildren() {
		//- no children for this node
		return new IProxyNode[0];
	}
	
	public String getFactoryID() {
		return EMFResourceProxyFactory.ID; 
	}
	
	public boolean saveState(IMemento memento) {
		//- data to retrieve the correct object 
		memento.putString(TestUIConstants.TAG_NODE_KIND, TestUIConstants.LOCATION_NODE);
		return super.saveState(memento);	
	}
	
	protected String getNodeKind() {
    	return TestUIConstants.LOCATION_NODE;
    }
	
}
