/*******************************************************************************
 * Copyright (c) 2005, 2010 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: NonEMFResourceProxyFactory.java,v 1.8 2010/05/07 13:03:06 paules Exp $
 * 
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator.proxy;

import org.eclipse.core.resources.IFile;
import org.eclipse.hyades.test.core.internal.ITestCommonConstants;
import org.eclipse.hyades.test.ui.navigator.IFileProxyFactory;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;

/**
 * <p>NonEMFResourceProxyFactory.java</p>
 * 
 * 
 * @author  Paul E. Slauenwhite
 * @version May 7, 2010
 * @since   April 22, 2005
 */
public class NonEMFResourceProxyFactory  implements IFileProxyFactory {

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.test.ui.navigator.IFileProxyFactory#create(org.eclipse.core.resources.IFile, java.lang.Object)
	 */
	public IProxyNode create(IFile file, Object parent) {
		
		String fileExtension = file.getFileExtension();
		
		if(fileExtension != null){
			
			fileExtension = fileExtension.trim();
			
			if(fileExtension.equalsIgnoreCase(ITestCommonConstants.HTML_FILE_EXTENSION)) {
				return (new HTMLFileProxyNode(file, parent));
			} 
			else if(fileExtension.equalsIgnoreCase(ITestCommonConstants.XML_FILE_EXTENSION)) {
				return (new XMLFileProxyNode(file, parent));
			} 
			else if(fileExtension.equalsIgnoreCase(ITestCommonConstants.RTF_FILE_EXTENSION)) {
				return (new RTFFileProxyNode(file, parent));
			} 
			else if(fileExtension.equalsIgnoreCase(ITestCommonConstants.TESTLOG_FILE_EXTENSION)) {
				return (new TestlogFileProxyNode(file, parent));
			}			
		}

		return null;
	}
}
